/*
 * Decompiled with CFR 0.152.
 */
package com.dragon.tools.utils;

import com.dragon.tools.vo.excel.ExportExcelVo;
import com.github.liaochong.myexcel.core.Csv;
import com.github.liaochong.myexcel.core.CsvBuilder;
import com.github.liaochong.myexcel.core.DefaultExcelBuilder;
import com.github.liaochong.myexcel.core.DefaultExcelReader;
import com.github.liaochong.myexcel.utils.AttachmentExportUtil;
import com.github.liaochong.myexcel.utils.FileExportUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.User;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.lang.NonNull;

public class ExcelCvsUtils<T> {
    private Class<T> dataType;

    public ExcelCvsUtils(Class<T> dataType) {
        this.dataType = dataType;
    }

    public static <T> ExcelCvsUtils<T> of(@NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return new ExcelCvsUtils<T>(clazz);
    }

    public List<T> importExcel(InputStream fileInputStream) throws Exception {
        List result = DefaultExcelReader.of(this.dataType).rowFilter(row -> row.getRowNum() > 0).read(fileInputStream);
        return result;
    }

    public static void exportCvsToFile(ExportExcelVo exportExcelVo) throws IOException {
        Csv csv = CsvBuilder.of((Class)exportExcelVo.getClazz()).build(exportExcelVo.getDatas(), new Class[0]);
        FileUtils.copyFile((File)csv.getFilePath().toFile(), (File)exportExcelVo.getFile());
    }

    public static void exportCvsToResponse(ExportExcelVo exportExcelVo) {
        Csv csv = CsvBuilder.of((Class)exportExcelVo.getClazz()).build(exportExcelVo.getDatas(), new Class[0]);
        AttachmentExportUtil.export((Path)csv.getFilePath(), (String)exportExcelVo.getFileName(), (HttpServletResponse)exportExcelVo.getResponse());
    }

    public static void exportExcelToFile(ExportExcelVo exportExcelVo) throws Exception {
        Workbook workbook = DefaultExcelBuilder.of((Class)exportExcelVo.getClazz()).build(exportExcelVo.getDatas(), new Class[0]);
        if (exportExcelVo.getFile() != null) {
            if (StringUtils.isNotBlank((String)exportExcelVo.getPassword())) {
                File dir = exportExcelVo.getFile().getParentFile();
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                FileExportUtil.encryptExport((Workbook)workbook, (File)exportExcelVo.getFile(), (String)exportExcelVo.getPassword());
            } else {
                FileExportUtil.export((Workbook)workbook, (File)exportExcelVo.getFile());
            }
        }
    }

    public static void exportExcelToResponse(ExportExcelVo exportExcelVo) {
        Workbook workbook = DefaultExcelBuilder.of((Class)exportExcelVo.getClazz()).build(exportExcelVo.getDatas(), new Class[0]);
        if (exportExcelVo.getResponse() != null) {
            String filename;
            String string = filename = exportExcelVo.getFileName() == null ? System.currentTimeMillis() + "" : exportExcelVo.getFileName();
            if (StringUtils.isNotBlank((String)exportExcelVo.getPassword())) {
                AttachmentExportUtil.encryptExport((Workbook)workbook, (String)filename, (HttpServletResponse)exportExcelVo.getResponse(), (String)exportExcelVo.getPassword());
            } else {
                AttachmentExportUtil.export((Workbook)workbook, (String)filename, (HttpServletResponse)exportExcelVo.getResponse());
            }
        }
    }

    public static void main(String[] args) throws Exception {
        ExcelCvsUtils.of(User.class).importExcel(new FileInputStream(new File("")));
    }
}

