/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.spring.boot.core.merchant.bean;

import com.egzosn.pay.common.api.PayService;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.fuiou.api.FuiouPayConfigStorage;
import com.egzosn.pay.spring.boot.core.PayConfigurerAdapter;
import com.egzosn.pay.spring.boot.core.builders.InMemoryMerchantDetailsServiceBuilder;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatform;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatformMerchantDetails;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatformServiceAdapter;
import com.egzosn.pay.spring.boot.core.provider.merchant.platform.PaymentPlatforms;

public class FuiouMerchantDetails
extends FuiouPayConfigStorage
implements PaymentPlatformMerchantDetails,
PaymentPlatformServiceAdapter,
PayConfigurerAdapter<InMemoryMerchantDetailsServiceBuilder> {
    private String detailsId;
    private volatile PayService payService;
    private PaymentPlatform platform;
    private InMemoryMerchantDetailsServiceBuilder builder;
    private HttpConfigStorage httpConfigStorage;

    @Override
    public InMemoryMerchantDetailsServiceBuilder and() {
        this.initService();
        return this.getBuilder();
    }

    @Override
    public InMemoryMerchantDetailsServiceBuilder getBuilder() {
        return this.builder;
    }

    public FuiouMerchantDetails(InMemoryMerchantDetailsServiceBuilder builder) {
        this();
        this.builder = builder;
    }

    public FuiouMerchantDetails() {
        String platformName = "fuiouPay";
        this.setPayType(platformName);
        this.platform = PaymentPlatforms.getPaymentPlatform(platformName);
    }

    @Override
    public PaymentPlatform getPaymentPlatform() {
        return this.platform;
    }

    @Override
    public PaymentPlatformServiceAdapter initService() {
        if (null == this.payService) {
            this.payService = this.platform.getPayService(this, this.getHttpConfigStorage());
        }
        return this;
    }

    public PayService getPayService() {
        return this.payService;
    }

    @Override
    public HttpConfigStorage getHttpConfigStorage() {
        return this.httpConfigStorage;
    }

    public FuiouMerchantDetails httpConfigStorage(HttpConfigStorage httpConfigStorage) {
        this.httpConfigStorage = httpConfigStorage;
        return this;
    }

    public void setDetailsId(String detailsId) {
        this.detailsId = detailsId;
    }

    @Override
    public String getDetailsId() {
        return this.detailsId;
    }

    public FuiouMerchantDetails detailsId(String detailsId) {
        this.detailsId = detailsId;
        return this;
    }

    public FuiouMerchantDetails notifyUrl(String notifyUrl) {
        this.setNotifyUrl(notifyUrl);
        return this;
    }

    public FuiouMerchantDetails returnUrl(String returnUrl) {
        this.setReturnUrl(returnUrl);
        return this;
    }

    public FuiouMerchantDetails signType(String signType) {
        this.setSignType(signType);
        return this;
    }

    public FuiouMerchantDetails inputCharset(String inputCharset) {
        this.setInputCharset(inputCharset);
        return this;
    }

    public FuiouMerchantDetails test(boolean test) {
        this.setTest(test);
        return this;
    }

    public FuiouMerchantDetails mchntCd(String mchntCd) {
        this.setMchntCd(mchntCd);
        return this;
    }

    public FuiouMerchantDetails keyPrivate(String keyPrivate) {
        this.setKeyPrivate(keyPrivate);
        return this;
    }

    public FuiouMerchantDetails keyPublic(String keyPublic) {
        this.setKeyPublic(keyPublic);
        return this;
    }
}

