/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.spring.boot.core.merchant.bean;

import com.egzosn.pay.common.api.PayService;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.spring.boot.core.PayConfigurerAdapter;
import com.egzosn.pay.spring.boot.core.builders.InMemoryMerchantDetailsServiceBuilder;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatform;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatformMerchantDetails;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatformServiceAdapter;
import com.egzosn.pay.spring.boot.core.provider.merchant.platform.PaymentPlatforms;
import com.egzosn.pay.wx.api.WxPayConfigStorage;

public class WxMerchantDetails
extends WxPayConfigStorage
implements PaymentPlatformMerchantDetails,
PaymentPlatformServiceAdapter,
PayConfigurerAdapter<InMemoryMerchantDetailsServiceBuilder> {
    private String detailsId;
    private volatile PayService payService;
    private PaymentPlatform platform;
    private InMemoryMerchantDetailsServiceBuilder builder;
    private HttpConfigStorage httpConfigStorage;

    @Override
    public InMemoryMerchantDetailsServiceBuilder and() {
        this.initService();
        return this.getBuilder();
    }

    @Override
    public InMemoryMerchantDetailsServiceBuilder getBuilder() {
        return this.builder;
    }

    public WxMerchantDetails(InMemoryMerchantDetailsServiceBuilder builder) {
        this();
        this.builder = builder;
    }

    public WxMerchantDetails() {
        String platformName = "wxPay";
        this.setPayType(platformName);
        this.platform = PaymentPlatforms.getPaymentPlatform(platformName);
    }

    @Override
    public PaymentPlatform getPaymentPlatform() {
        return this.platform;
    }

    @Override
    public PaymentPlatformServiceAdapter initService() {
        if (null == this.payService) {
            this.payService = this.platform.getPayService(this, this.getHttpConfigStorage());
        }
        return this;
    }

    public PayService getPayService() {
        return this.payService;
    }

    @Override
    public HttpConfigStorage getHttpConfigStorage() {
        return this.httpConfigStorage;
    }

    public WxMerchantDetails httpConfigStorage(HttpConfigStorage httpConfigStorage) {
        this.httpConfigStorage = httpConfigStorage;
        return this;
    }

    @Override
    public String getDetailsId() {
        return this.detailsId;
    }

    public WxMerchantDetails detailsId(String detailsId) {
        this.detailsId = detailsId;
        return this;
    }

    public WxMerchantDetails notifyUrl(String notifyUrl) {
        this.setNotifyUrl(notifyUrl);
        return this;
    }

    public WxMerchantDetails returnUrl(String returnUrl) {
        this.setReturnUrl(returnUrl);
        return this;
    }

    public WxMerchantDetails signType(String signType) {
        this.setSignType(signType);
        return this;
    }

    public WxMerchantDetails inputCharset(String inputCharset) {
        this.setInputCharset(inputCharset);
        return this;
    }

    public WxMerchantDetails test(boolean test) {
        this.setTest(test);
        return this;
    }

    public WxMerchantDetails appid(String appid) {
        this.setAppid(appid);
        return this;
    }

    public WxMerchantDetails secretKey(String secretKey) {
        this.setSecretKey(secretKey);
        return this;
    }

    public WxMerchantDetails keyPublic(String keyPublic) {
        this.setKeyPublic(keyPublic);
        return this;
    }

    public WxMerchantDetails mchId(String mchId) {
        this.setMchId(mchId);
        return this;
    }

    public WxMerchantDetails subAppid(String subAppid) {
        this.setSubAppid(subAppid);
        return this;
    }

    public WxMerchantDetails subMchId(String subMchId) {
        this.setSubMchId(subMchId);
        return this;
    }
}

