/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.spring.boot.core.provider;

import com.egzosn.pay.spring.boot.core.configurers.PayMessageConfigurer;
import com.egzosn.pay.spring.boot.core.merchant.MerchantNotFoundException;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatformMerchantDetails;
import com.egzosn.pay.spring.boot.core.provider.MerchantDetailsManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;

public class CacheMerchantDetailsManager
implements MerchantDetailsManager<PaymentPlatformMerchantDetails> {
    private Map<String, PaymentPlatformMerchantDetails> merchantDetails = new HashMap<String, PaymentPlatformMerchantDetails>();
    private MerchantDetailsManager<PaymentPlatformMerchantDetails> delegate;

    public CacheMerchantDetailsManager(MerchantDetailsManager<PaymentPlatformMerchantDetails> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void createMerchant(PaymentPlatformMerchantDetails merchant) {
        Assert.isTrue((!this.merchantExists(merchant.getDetailsId()) ? 1 : 0) != 0, (String)"\u5546\u6237\u4fe1\u606f\u5df2\u5b58\u5728");
        this.merchantDetails.put(merchant.getDetailsId(), merchant);
        this.delegate.createMerchant(merchant);
    }

    @Override
    public void createMerchant(Collection<PaymentPlatformMerchantDetails> merchants) {
        for (PaymentPlatformMerchantDetails merchant : merchants) {
            this.createMerchant(merchant);
        }
    }

    @Override
    public void updateMerchant(PaymentPlatformMerchantDetails merchant) {
        Assert.isTrue((boolean)this.merchantExists(merchant.getDetailsId()), (String)"\u5546\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        this.merchantDetails.put(merchant.getDetailsId(), merchant);
        this.delegate.updateMerchant(merchant);
    }

    @Override
    public void deleteMerchant(String id) {
        this.merchantDetails.remove(id);
        this.delegate.deleteMerchant(id);
    }

    @Override
    public boolean merchantExists(String id) {
        boolean exist = this.merchantDetails.containsKey(id);
        if (exist) {
            return exist;
        }
        return this.delegate.merchantExists(id);
    }

    @Override
    public void setPayMessageConfigurer(PayMessageConfigurer configurer) {
        this.delegate.setPayMessageConfigurer(configurer);
    }

    @Override
    public PaymentPlatformMerchantDetails loadMerchantByMerchantId(String merchantId) {
        PaymentPlatformMerchantDetails details = this.merchantDetails.get(merchantId);
        if (null != details) {
            return details;
        }
        details = (PaymentPlatformMerchantDetails)this.delegate.loadMerchantByMerchantId(merchantId);
        if (null == details) {
            throw new MerchantNotFoundException(merchantId);
        }
        this.merchantDetails.put(details.getDetailsId(), details);
        return details;
    }
}

