/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.spring.boot.core.provider;

import com.egzosn.pay.common.api.PayMessageHandler;
import com.egzosn.pay.common.api.PayMessageInterceptor;
import com.egzosn.pay.common.api.PayService;
import com.egzosn.pay.common.bean.PayMessage;
import com.egzosn.pay.spring.boot.core.configurers.PayMessageConfigurer;
import com.egzosn.pay.spring.boot.core.merchant.MerchantNotFoundException;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatformMerchantDetails;
import com.egzosn.pay.spring.boot.core.provider.MerchantDetailsManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.util.Assert;

public class InMemoryMerchantDetailsManager
implements MerchantDetailsManager<PaymentPlatformMerchantDetails> {
    private Map<String, PaymentPlatformMerchantDetails> merchantDetails = new HashMap<String, PaymentPlatformMerchantDetails>();
    private PayMessageConfigurer configurer;

    public InMemoryMerchantDetailsManager() {
    }

    public InMemoryMerchantDetailsManager(Collection<PaymentPlatformMerchantDetails> merchantDetails) {
        this.createMerchant(merchantDetails);
    }

    public InMemoryMerchantDetailsManager(Map<String, PaymentPlatformMerchantDetails> merchantDetails) {
        this.merchantDetails = merchantDetails;
    }

    public InMemoryMerchantDetailsManager(Properties merchants) {
    }

    @Override
    public void createMerchant(Collection<PaymentPlatformMerchantDetails> merchants) {
        for (PaymentPlatformMerchantDetails merchant : merchants) {
            this.createMerchant(merchant);
        }
    }

    @Override
    public void createMerchant(PaymentPlatformMerchantDetails merchant) {
        Assert.isTrue((!this.merchantExists(merchant.getDetailsId()) ? 1 : 0) != 0, (String)"\u5546\u6237\u4fe1\u606f\u5df2\u5b58\u5728");
        InMemoryMerchantDetailsManager.setPayMessageConfigurer(merchant.getPayService(), merchant, this.configurer);
        this.merchantDetails.put(merchant.getDetailsId(), merchant);
    }

    protected static void setPayMessageConfigurer(PayService payService, PaymentPlatformMerchantDetails details, PayMessageConfigurer configurer) {
        List<PayMessageInterceptor<PayMessage, PayService>> interceptors;
        PayMessageHandler<PayMessage, PayService> handler = configurer.getHandler(details.getPaymentPlatform());
        if (null != handler) {
            payService.setPayMessageHandler(handler);
        }
        if (null == (interceptors = configurer.getInterceptor(details.getPaymentPlatform())) || interceptors.isEmpty()) {
            return;
        }
        for (PayMessageInterceptor<PayMessage, PayService> interceptor : interceptors) {
            payService.addPayMessageInterceptor(interceptor);
        }
    }

    @Override
    public void updateMerchant(PaymentPlatformMerchantDetails merchant) {
        Assert.isTrue((boolean)this.merchantExists(merchant.getDetailsId()), (String)"\u5546\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        this.merchantDetails.put(merchant.getDetailsId(), merchant);
    }

    @Override
    public void deleteMerchant(String id) {
        this.merchantDetails.remove(id);
    }

    @Override
    public boolean merchantExists(String id) {
        return this.merchantDetails.containsKey(id);
    }

    @Override
    public void setPayMessageConfigurer(PayMessageConfigurer configurer) {
        this.configurer = configurer;
    }

    @Override
    public PaymentPlatformMerchantDetails loadMerchantByMerchantId(String merchantId) {
        PaymentPlatformMerchantDetails details = this.merchantDetails.get(merchantId);
        if (null == details) {
            throw new MerchantNotFoundException(merchantId);
        }
        return details;
    }
}

