/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.spring.boot.core.provider.merchant.platform;

import com.egzosn.pay.common.api.PayConfigStorage;
import com.egzosn.pay.common.api.PayService;
import com.egzosn.pay.common.bean.TransactionType;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.fuiou.api.FuiouPayConfigStorage;
import com.egzosn.pay.fuiou.api.FuiouPayService;
import com.egzosn.pay.fuiou.bean.FuiouTransactionType;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="fuiouPay")
@ConditionalOnMissingBean(value={FuiouPaymentPlatform.class})
@ConditionalOnClass(name={"com.egzosn.pay.fuiou.api.FuiouPayConfigStorage"})
public class FuiouPaymentPlatform
implements PaymentPlatform {
    public static final String PLATFORM_NAME = "fuiouPay";
    @Deprecated
    public static final String platformName = "fuiouPay";

    @Override
    public String getPlatform() {
        return "fuiouPay";
    }

    public PayService getPayService(PayConfigStorage payConfigStorage) {
        if (payConfigStorage instanceof FuiouPayConfigStorage) {
            return new FuiouPayService((FuiouPayConfigStorage)payConfigStorage);
        }
        FuiouPayConfigStorage configStorage = new FuiouPayConfigStorage();
        configStorage.setMchntCd(payConfigStorage.getPid());
        configStorage.setNotifyUrl(payConfigStorage.getNotifyUrl());
        configStorage.setReturnUrl(payConfigStorage.getReturnUrl());
        configStorage.setSignType(payConfigStorage.getSignType());
        configStorage.setPayType(payConfigStorage.getPayType());
        configStorage.setInputCharset(payConfigStorage.getInputCharset());
        configStorage.setTest(payConfigStorage.isTest());
        return new FuiouPayService(configStorage);
    }

    public PayService getPayService(PayConfigStorage payConfigStorage, HttpConfigStorage httpConfigStorage) {
        PayService payService = this.getPayService(payConfigStorage);
        payService.setRequestTemplateConfigStorage(httpConfigStorage);
        return payService;
    }

    public TransactionType getTransactionType(String name) {
        return FuiouTransactionType.valueOf((String)name);
    }
}

