/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.spring.boot.core.provider.merchant.platform;

import com.egzosn.pay.common.api.PayConfigStorage;
import com.egzosn.pay.common.api.PayService;
import com.egzosn.pay.common.bean.CertStoreType;
import com.egzosn.pay.common.bean.TransactionType;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatform;
import com.egzosn.pay.spring.boot.core.merchant.bean.CommonPaymentPlatformMerchantDetails;
import com.egzosn.pay.wx.v3.api.WxPayConfigStorage;
import com.egzosn.pay.wx.v3.api.WxProfitSharingService;
import com.egzosn.pay.wx.v3.bean.WxTransactionType;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="wxV3ProfitSharing")
@ConditionalOnMissingBean(value={WxV3ProfitSharingPlatform.class})
@ConditionalOnClass(name={"com.egzosn.pay.wx.v3.api.WxPayConfigStorage"})
public class WxV3ProfitSharingPlatform
extends WxPayConfigStorage
implements PaymentPlatform {
    private final Log LOG = LogFactory.getLog(WxV3ProfitSharingPlatform.class);
    public static final String PLATFORM_NAME = "wxV3ProfitSharing";
    @Deprecated
    public static final String platformName = "wxV3ProfitSharing";

    @Override
    public String getPlatform() {
        return "wxV3ProfitSharing";
    }

    public PayService getPayService(PayConfigStorage payConfigStorage) {
        return this.getPayService(payConfigStorage, null);
    }

    public PayService getPayService(PayConfigStorage payConfigStorage, HttpConfigStorage httpConfigStorage) {
        if (payConfigStorage instanceof WxPayConfigStorage) {
            WxProfitSharingService wxPayService = new WxProfitSharingService((WxPayConfigStorage)payConfigStorage);
            wxPayService.setRequestTemplateConfigStorage(httpConfigStorage);
            return wxPayService;
        }
        WxPayConfigStorage configStorage = new WxPayConfigStorage();
        configStorage.setInputCharset(payConfigStorage.getInputCharset());
        configStorage.setAppId(payConfigStorage.getAppId());
        configStorage.setMchId(payConfigStorage.getPid());
        configStorage.setAttach(payConfigStorage.getAttach());
        configStorage.setV3ApiKey(payConfigStorage.getKeyPrivate());
        configStorage.setKeyPublic(payConfigStorage.getKeyPublic());
        configStorage.setNotifyUrl(payConfigStorage.getNotifyUrl());
        configStorage.setReturnUrl(payConfigStorage.getReturnUrl());
        configStorage.setPayType(payConfigStorage.getPayType());
        configStorage.setTest(payConfigStorage.isTest());
        configStorage.setSignType(payConfigStorage.getSignType());
        if (payConfigStorage instanceof CommonPaymentPlatformMerchantDetails) {
            CommonPaymentPlatformMerchantDetails merchantDetails = (CommonPaymentPlatformMerchantDetails)payConfigStorage;
            configStorage.setSubAppId(merchantDetails.getSubAppId());
            configStorage.setSubMchId(merchantDetails.getSubMchId());
            if (null != merchantDetails.getKeyCert()) {
                configStorage.setCertStoreType(merchantDetails.getCertStoreType());
                try {
                    configStorage.setApiClientKeyP12((Object)merchantDetails.getKeyCertInputStream());
                }
                catch (IOException e) {
                    this.LOG.error((Object)e);
                }
                configStorage.setCertStoreType(CertStoreType.INPUT_STREAM);
            }
        }
        WxProfitSharingService wxPayService = new WxProfitSharingService(configStorage);
        wxPayService.setRequestTemplateConfigStorage(httpConfigStorage);
        return wxPayService;
    }

    public TransactionType getTransactionType(String name) {
        return WxTransactionType.valueOf((String)name);
    }
}

