/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.spring.boot.core.provider.merchant.platform;

import com.egzosn.pay.common.api.PayConfigStorage;
import com.egzosn.pay.common.api.PayService;
import com.egzosn.pay.common.bean.TransactionType;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatform;
import com.egzosn.pay.wx.youdian.api.WxYouDianPayConfigStorage;
import com.egzosn.pay.wx.youdian.api.WxYouDianPayService;
import com.egzosn.pay.wx.youdian.bean.YoudianTransactionType;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="youdianPay")
@ConditionalOnMissingBean(value={YoudianPaymentPlatform.class})
@ConditionalOnClass(name={"com.egzosn.pay.wx.youdian.api.WxYouDianPayConfigStorage"})
public class YoudianPaymentPlatform
implements PaymentPlatform {
    public static final String PLATFORM_NAME = "youdianPay";
    @Deprecated
    public static final String platformName = "youdianPay";

    @Override
    public String getPlatform() {
        return "youdianPay";
    }

    public PayService getPayService(PayConfigStorage payConfigStorage) {
        if (payConfigStorage instanceof WxYouDianPayConfigStorage) {
            return new WxYouDianPayService((WxYouDianPayConfigStorage)payConfigStorage);
        }
        WxYouDianPayConfigStorage configStorage = new WxYouDianPayConfigStorage();
        configStorage.setKeyPrivate(payConfigStorage.getKeyPrivate());
        configStorage.setKeyPublic(payConfigStorage.getKeyPublic());
        configStorage.setSignType(payConfigStorage.getSignType());
        configStorage.setPayType(payConfigStorage.getPayType());
        configStorage.setSeller(payConfigStorage.getSeller());
        configStorage.setInputCharset(payConfigStorage.getInputCharset());
        configStorage.setTest(payConfigStorage.isTest());
        return new WxYouDianPayService(configStorage);
    }

    public PayService getPayService(PayConfigStorage payConfigStorage, HttpConfigStorage httpConfigStorage) {
        PayService payService = this.getPayService(payConfigStorage);
        payService.setRequestTemplateConfigStorage(httpConfigStorage);
        return payService;
    }

    public TransactionType getTransactionType(String name) {
        return YoudianTransactionType.valueOf((String)name);
    }
}

