/*
 * Decompiled with CFR 0.152.
 */
package com.envoisolutions.sxc.xpath;

import com.envoisolutions.sxc.Context;
import com.envoisolutions.sxc.builder.Builder;
import com.envoisolutions.sxc.builder.CodeBody;
import com.envoisolutions.sxc.builder.ElementParserBuilder;
import com.envoisolutions.sxc.builder.ParserBuilder;
import com.envoisolutions.sxc.builder.impl.BuilderImpl;
import com.envoisolutions.sxc.xpath.XPathEvaluator;
import com.envoisolutions.sxc.xpath.XPathEvent;
import com.envoisolutions.sxc.xpath.XPathEventHandler;
import com.envoisolutions.sxc.xpath.XPathException;
import com.envoisolutions.sxc.xpath.impl.XPathEvaluatorImpl;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jaxen.JaxenHandler;
import org.jaxen.expr.AllNodeStep;
import org.jaxen.expr.EqualityExpr;
import org.jaxen.expr.Expr;
import org.jaxen.expr.FunctionCallExpr;
import org.jaxen.expr.LiteralExpr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.LogicalExpr;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.NumberExpr;
import org.jaxen.expr.Predicate;
import org.jaxen.expr.TextNodeStep;
import org.jaxen.expr.XPathExpr;
import org.jaxen.saxpath.SAXPathException;
import org.jaxen.saxpath.XPathHandler;
import org.jaxen.saxpath.XPathReader;
import org.jaxen.saxpath.helpers.XPathReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathBuilder {
    private Map<String, String> namespaceContext;
    private ElementParserBuilder parserBldr;
    private Map<String, XPathEventHandler> eventHandlers = new HashMap<String, XPathEventHandler>();
    private Map<String, Object> vars = new HashMap<String, Object>();
    private JType eventHandlerType;
    private JType stringType;
    private Builder builder = new BuilderImpl();
    private JType eventType;
    private int varCount = 0;
    private int elementCounters = 0;
    private JPrimitiveType boolType;
    private JPrimitiveType intType;
    private JCodeModel model;

    public XPathBuilder() {
        this.parserBldr = this.builder.getParserBuilder();
        this.model = this.parserBldr.getCodeModel();
        this.eventHandlerType = this.model._ref(XPathEventHandler.class);
        this.eventType = this.model._ref(XPathEvent.class);
        this.stringType = this.model._ref(String.class);
        this.boolType = this.model.BOOLEAN;
        this.intType = this.model.INT;
    }

    public void listen(String expr, XPathEventHandler handler) {
        this.eventHandlers.put(expr, handler);
    }

    public XPathEvaluator compile() {
        for (Map.Entry<String, XPathEventHandler> e : this.eventHandlers.entrySet()) {
            this.compileEventHandler(e.getKey(), e.getValue());
        }
        Context context = this.builder.compile();
        context.putAll(this.vars);
        return new XPathEvaluatorImpl(context);
    }

    public void compileEventHandler(String expr, XPathEventHandler eventHandler) {
        String varName = "obj" + this.vars.size();
        this.vars.put(varName, eventHandler);
        ElementParserBuilder xpathBuilder = this.parserBldr;
        try {
            XPathReader reader = XPathReaderFactory.createReader();
            JaxenHandler handler = new JaxenHandler();
            reader.setXPathHandler((XPathHandler)handler);
            reader.parse(expr);
            XPathExpr path = handler.getXPathExpr(true);
            Object o = this.handleExpression(this.parserBldr, path.getRootExpr());
            if (o instanceof ExpressionState) {
                ExpressionState exp = (ExpressionState)o;
                JVar var = exp.getVar();
                ParserBuilder builder = exp.getBuilder();
                JBlock block = builder.getBody().getBlock();
                xpathBuilder = builder.newState(block._if((JExpression)var)._then());
            } else {
                xpathBuilder = (ParserBuilder)o;
            }
        }
        catch (SAXPathException e) {
            throw new XPathException(e);
        }
        CodeBody body = xpathBuilder.getBody();
        JVar handlerVar = body.decl(this.eventHandlerType, varName, (JExpression)JExpr.cast((JType)this.eventHandlerType, (JExpression)JExpr._super().ref("context").invoke("get").arg(varName)));
        body.add((JStatement)handlerVar.invoke("onMatch").arg((JExpression)JExpr._new((JType)this.eventType).arg(JExpr.lit((String)expr)).arg((JExpression)xpathBuilder.getXSR())));
    }

    private Object handleExpression(ElementParserBuilder xpathBuilder, Expr expr) {
        if (expr instanceof LocationPath) {
            return this.handle(xpathBuilder, (LocationPath)expr);
        }
        if (expr instanceof EqualityExpr) {
            return this.handle(xpathBuilder, (EqualityExpr)expr);
        }
        if (expr instanceof LiteralExpr) {
            return this.handle(xpathBuilder, (LiteralExpr)expr);
        }
        if (expr instanceof FunctionCallExpr) {
            return this.handle(xpathBuilder, (FunctionCallExpr)expr);
        }
        if (expr instanceof LogicalExpr) {
            return this.handle(xpathBuilder, (LogicalExpr)expr);
        }
        if (expr instanceof NumberExpr) {
            return this.handle(xpathBuilder, (NumberExpr)expr);
        }
        throw new XPathException("Unknown expression type " + expr);
    }

    private ExpressionState handle(ElementParserBuilder xpathBuilder, LiteralExpr expr) {
        JVar var = xpathBuilder.getBody().decl(this.stringType, "_literal" + this.varCount++, JExpr.lit((String)expr.getLiteral()));
        return new ExpressionState((ParserBuilder)xpathBuilder, var);
    }

    private ParserBuilder handle(ElementParserBuilder parent, LogicalExpr expr) {
        JBlock newBlock;
        Object left = this.handleExpression(parent, expr.getLHS());
        Object right = this.handleExpression(parent, expr.getRHS());
        JBlock block = parent.getBody().getBlock();
        JVar b1 = ((ExpressionState)left).getVar();
        JVar b2 = ((ExpressionState)right).getVar();
        String op = expr.getOperator();
        if (op.equals("and")) {
            newBlock = block._if(b1.cand((JExpression)b2))._then();
        } else if (op.equals("or")) {
            newBlock = block._if(b1.cor((JExpression)b2))._then();
        } else {
            throw new UnsupportedOperationException("Operator " + op + " is not supported");
        }
        return parent.newState(newBlock);
    }

    private ExpressionState handle(ElementParserBuilder xpathBuilder, FunctionCallExpr expr) {
        JVar var;
        String name = "functValue" + this.varCount++;
        String functionName = expr.getFunctionName();
        if ("local-name".equals(functionName)) {
            var = xpathBuilder.getBody().decl(this.stringType, name, (JExpression)xpathBuilder.getXSR().invoke("getLocalName"));
        } else if ("namespace-uri".equals(functionName)) {
            var = xpathBuilder.getBody().decl(this.stringType, name, (JExpression)xpathBuilder.getXSR().invoke("getNamespaceURI"));
        } else {
            throw new XPathException("Function " + functionName + " is not understood!");
        }
        return new ExpressionState((ParserBuilder)xpathBuilder, var);
    }

    private ExpressionState handle(ElementParserBuilder parent, EqualityExpr expr) {
        ExpressionState left = (ExpressionState)this.handleExpression(parent, expr.getLHS());
        ExpressionState right = (ExpressionState)this.handleExpression(parent, expr.getRHS());
        JVar var = parent.getBody().decl((JType)this.boolType, "b" + this.varCount++, (JExpression)left.getVar().invoke("equals").arg((JExpression)right.getVar()));
        return new ExpressionState((ParserBuilder)parent, var);
    }

    private Object handle(ElementParserBuilder xpathBuilder, LocationPath path) {
        Object returnObj = xpathBuilder;
        boolean globalElement = false;
        for (Object o : path.getSteps()) {
            if (o instanceof NameStep) {
                returnObj = this.handleNameStep((ParserBuilder)returnObj, (NameStep)o, globalElement);
                globalElement = false;
                continue;
            }
            if (o instanceof AllNodeStep) {
                globalElement = true;
                continue;
            }
            if (o instanceof TextNodeStep) {
                returnObj = this.handleTextNodeStep((ParserBuilder)returnObj, (TextNodeStep)o);
                continue;
            }
            throw new XPathException("Unsupported expression: " + o);
        }
        return returnObj;
    }

    private ExpressionState handleTextNodeStep(ParserBuilder returnBuilder, TextNodeStep step) {
        JVar var = returnBuilder.as(String.class);
        return new ExpressionState(returnBuilder, var);
    }

    private Object handleNameStep(ParserBuilder returnBuilder, NameStep step, boolean globalElement) {
        String prefix = step.getPrefix();
        String ns = "";
        if (prefix != null && !prefix.equals("") && (ns = this.namespaceContext.get(prefix)) == null) {
            throw new XPathException("Could not find namespace for prefix: " + prefix);
        }
        QName n = new QName(ns, step.getLocalName());
        ElementParserBuilder elBuilder = (ElementParserBuilder)returnBuilder;
        if (step.getAxis() == 1) {
            returnBuilder = n.getLocalPart().equals("*") ? elBuilder.expectAnyElement() : (globalElement ? elBuilder.expectGlobalElement(n) : elBuilder.expectElement(n));
        } else if (step.getAxis() == 9) {
            returnBuilder = elBuilder.expectAttribute(n);
        } else {
            throw new XPathException("Unsupported axis: " + step.getAxis());
        }
        return this.handlePredicates(returnBuilder, step.getPredicateSet().getPredicates());
    }

    private Object handle(ElementParserBuilder xpathBuilder, NumberExpr expr) {
        JBlock block = xpathBuilder.getBody().getBlock();
        JVar counterVar = this.parserBldr.getBody().field(1, (JType)this.intType, "counter" + this.elementCounters++, JExpr.lit((int)0));
        block.assignPlus((JAssignmentTarget)counterVar, JExpr.lit((int)1));
        JBlock then = block._if(counterVar.eq(JExpr.lit((int)((int)Double.valueOf(expr.getText()).doubleValue()))))._then();
        return xpathBuilder.newState(then);
    }

    private Object handlePredicates(ParserBuilder returnBuilder, List<?> predicates) {
        Object returnObj = returnBuilder;
        for (Predicate p : predicates) {
            returnObj = this.handleExpression((ElementParserBuilder)returnObj, p.getExpr());
        }
        return returnObj;
    }

    public Map<String, String> getNamespaceContext() {
        return this.namespaceContext;
    }

    public void setNamespaceContext(Map<String, String> namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    public void addPrefix(String prefix, String namespace) {
        if (this.namespaceContext == null) {
            this.namespaceContext = new HashMap<String, String>();
        }
        this.namespaceContext.put(prefix, namespace);
    }

    public void addAllPrefixes(Map<String, String> prefixes) {
        if (this.namespaceContext == null) {
            this.namespaceContext = new HashMap<String, String>();
        }
        this.namespaceContext.putAll(prefixes);
    }

    public static class ExpressionState {
        private JVar var;
        private ParserBuilder builder;

        public ExpressionState(ParserBuilder builder, JVar var) {
            this.builder = builder;
            this.var = var;
        }

        public ParserBuilder getBuilder() {
            return this.builder;
        }

        public void setBuilder(ParserBuilder builder) {
            this.builder = builder;
        }

        public JVar getVar() {
            return this.var;
        }

        public void setVar(JVar var) {
            this.var = var;
        }
    }
}

