/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.unsafe;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.ByteBufferOutput;
import com.esotericsoftware.kryo.unsafe.UnsafeUtil;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import sun.nio.ch.DirectBuffer;

public class UnsafeByteBufferOutput
extends ByteBufferOutput {
    private long bufferAddress;

    public UnsafeByteBufferOutput() {
    }

    public UnsafeByteBufferOutput(int bufferSize) {
        super(bufferSize);
        this.updateBufferAddress();
    }

    public UnsafeByteBufferOutput(int bufferSize, int maxBufferSize) {
        super(bufferSize, maxBufferSize);
        this.updateBufferAddress();
    }

    public UnsafeByteBufferOutput(OutputStream outputStream) {
        super(outputStream);
        this.updateBufferAddress();
    }

    public UnsafeByteBufferOutput(OutputStream outputStream, int bufferSize) {
        super(outputStream, bufferSize);
        this.updateBufferAddress();
    }

    public UnsafeByteBufferOutput(long address, int size) {
        super(UnsafeUtil.newDirectBuffer(address, size));
        this.updateBufferAddress();
    }

    @Override
    public void setBuffer(ByteBuffer buffer, int maxBufferSize) {
        if (!(buffer instanceof DirectBuffer)) {
            throw new IllegalArgumentException("buffer must be direct.");
        }
        if (buffer != this.byteBuffer) {
            UnsafeUtil.dispose(this.byteBuffer);
        }
        super.setBuffer(buffer, maxBufferSize);
        this.updateBufferAddress();
    }

    private void updateBufferAddress() {
        this.bufferAddress = ((DirectBuffer)((Object)this.byteBuffer)).address();
    }

    @Override
    protected boolean require(int required) throws KryoException {
        ByteBuffer oldBuffer = this.byteBuffer;
        boolean result = super.require(required);
        if (this.byteBuffer != oldBuffer) {
            UnsafeUtil.dispose(oldBuffer);
            this.updateBufferAddress();
        }
        return result;
    }

    public void dispose() {
        UnsafeUtil.dispose(this.byteBuffer);
        this.byteBuffer = null;
        this.bufferAddress = 0L;
    }

    @Override
    public void write(int value) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        UnsafeUtil.unsafe.putByte(this.bufferAddress + (long)this.position++, (byte)value);
        this.byteBuffer.position(this.position);
    }

    @Override
    public void writeByte(byte value) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        UnsafeUtil.unsafe.putByte(this.bufferAddress + (long)this.position++, value);
        this.byteBuffer.position(this.position);
    }

    @Override
    public void writeByte(int value) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        UnsafeUtil.unsafe.putByte(this.bufferAddress + (long)this.position++, (byte)value);
        this.byteBuffer.position(this.position);
    }

    @Override
    public void writeInt(int value) throws KryoException {
        this.require(4);
        UnsafeUtil.unsafe.putInt(this.bufferAddress + (long)this.position, value);
        this.position += 4;
        this.byteBuffer.position(this.position);
    }

    @Override
    public void writeLong(long value) throws KryoException {
        this.require(8);
        UnsafeUtil.unsafe.putLong(this.bufferAddress + (long)this.position, value);
        this.position += 8;
        this.byteBuffer.position(this.position);
    }

    @Override
    public void writeFloat(float value) throws KryoException {
        this.require(4);
        UnsafeUtil.unsafe.putFloat(this.bufferAddress + (long)this.position, value);
        this.position += 4;
        this.byteBuffer.position(this.position);
    }

    @Override
    public void writeDouble(double value) throws KryoException {
        this.require(8);
        UnsafeUtil.unsafe.putDouble(this.bufferAddress + (long)this.position, value);
        this.position += 8;
        this.byteBuffer.position(this.position);
    }

    @Override
    public void writeShort(int value) throws KryoException {
        this.require(2);
        UnsafeUtil.unsafe.putShort(this.bufferAddress + (long)this.position, (short)value);
        this.position += 2;
        this.byteBuffer.position(this.position);
    }

    @Override
    public void writeChar(char value) throws KryoException {
        this.require(2);
        UnsafeUtil.unsafe.putChar(this.bufferAddress + (long)this.position, value);
        this.position += 2;
        this.byteBuffer.position(this.position);
    }

    @Override
    public void writeBoolean(boolean value) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        UnsafeUtil.unsafe.putByte(this.bufferAddress + (long)this.position++, value ? (byte)1 : 0);
        this.byteBuffer.position(this.position);
    }

    @Override
    public void writeInts(int[] array, int offset, int count) throws KryoException {
        this.writeBytes(array, UnsafeUtil.intArrayBaseOffset, array.length << 2);
    }

    @Override
    public void writeLongs(long[] array, int offset, int count) throws KryoException {
        this.writeBytes(array, UnsafeUtil.longArrayBaseOffset, array.length << 3);
    }

    @Override
    public void writeFloats(float[] array, int offset, int count) throws KryoException {
        this.writeBytes(array, UnsafeUtil.floatArrayBaseOffset, array.length << 2);
    }

    @Override
    public void writeDoubles(double[] array, int offset, int count) throws KryoException {
        this.writeBytes(array, UnsafeUtil.doubleArrayBaseOffset, array.length << 3);
    }

    @Override
    public void writeShorts(short[] array, int offset, int count) throws KryoException {
        this.writeBytes(array, UnsafeUtil.shortArrayBaseOffset, array.length << 1);
    }

    @Override
    public void writeChars(char[] array, int offset, int count) throws KryoException {
        this.writeBytes(array, UnsafeUtil.charArrayBaseOffset, array.length << 1);
    }

    @Override
    public void writeBooleans(boolean[] array, int offset, int count) throws KryoException {
        this.writeBytes(array, UnsafeUtil.booleanArrayBaseOffset, array.length);
    }

    @Override
    public void writeBytes(byte[] array, int offset, int count) throws KryoException {
        this.writeBytes((Object)array, UnsafeUtil.byteArrayBaseOffset + (long)offset, count);
    }

    public void writeBytes(Object from, long offset, int count) throws KryoException {
        int copyCount = Math.min(this.capacity - this.position, count);
        while (true) {
            UnsafeUtil.unsafe.copyMemory(from, offset, null, this.bufferAddress + (long)this.position, copyCount);
            this.position += copyCount;
            if ((count -= copyCount) == 0) break;
            offset += (long)copyCount;
            copyCount = Math.min(this.capacity, count);
            this.require(copyCount);
        }
        this.byteBuffer.position(this.position);
    }
}

