/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.concurrent;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public final class ThreadLocalCache<K, V> {
    private final ThreadLocal<Map<K, V>> cache;
    private final Function<K, V> loader;

    public ThreadLocalCache(int maxSizePerThread, Function<K, V> loader) {
        Preconditions.checkArgument((maxSizePerThread > 0 ? 1 : 0) != 0, (Object)"max size must be greater than zero");
        this.cache = ThreadLocal.withInitial(() -> new BoundedMap(maxSizePerThread));
        this.loader = Objects.requireNonNull(loader, "loader is null");
    }

    public V get(K key) {
        V value = this.cache.get().computeIfAbsent(key, this.loader);
        return Objects.requireNonNull(value, "loader returned null value");
    }

    private static class BoundedMap<K, V>
    extends LinkedHashMap<K, V> {
        private final int maxSize;

        public BoundedMap(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxSize;
        }
    }
}

