/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.zorder;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ZValueRange {
    private final List<Integer> minimumValues;
    private final List<Integer> maximumValues;

    public ZValueRange(List<Optional<Integer>> minimumValues, List<Optional<Integer>> maximumValues) {
        this.minimumValues = minimumValues.stream().map(optionalInteger -> optionalInteger.orElse(null)).collect(Collectors.toList());
        this.maximumValues = maximumValues.stream().map(optionalInteger -> optionalInteger.orElse(null)).collect(Collectors.toList());
    }

    public List<Integer> getMinimumValues(int maximumBits) {
        return this.minimumValues.stream().map(x -> x == null ? -(1 << maximumBits) : x).collect(Collectors.toList());
    }

    public List<Integer> getMaximumValues(int maximumBits) {
        return this.maximumValues.stream().map(x -> x == null ? (1 << maximumBits) - 1 : x).collect(Collectors.toList());
    }
}

