/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.foxinmy.weixin4j.api.MchApi;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Pageable;
import com.foxinmy.weixin4j.model.WeixinPayAccount;
import com.foxinmy.weixin4j.payment.mch.CorpPayment;
import com.foxinmy.weixin4j.payment.mch.CorpPaymentRecord;
import com.foxinmy.weixin4j.payment.mch.CorpPaymentResult;
import com.foxinmy.weixin4j.payment.mch.Redpacket;
import com.foxinmy.weixin4j.payment.mch.RedpacketRecord;
import com.foxinmy.weixin4j.payment.mch.RedpacketSendResult;
import com.foxinmy.weixin4j.payment.mch.SettlementRecord;
import com.foxinmy.weixin4j.type.CurrencyType;
import com.foxinmy.weixin4j.util.DateUtil;
import com.foxinmy.weixin4j.util.RandomUtil;
import com.foxinmy.weixin4j.xml.XmlStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

public class CashApi
extends MchApi {
    public CashApi(WeixinPayAccount weixinAccount) {
        super(weixinAccount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RedpacketSendResult sendRedpack(InputStream certificate, Redpacket redpacket) throws WeixinException {
        redpacket.declareWeixinPayAccount(this.weixinAccount);
        JSONObject obj = (JSONObject)JSON.toJSON((Object)redpacket);
        obj.put("wxappid", obj.remove((Object)"appid"));
        obj.put("sign", (Object)this.weixinSignature.sign(obj));
        String param = XmlStream.map2xml(obj);
        WeixinResponse response = null;
        try {
            response = this.createSSLRequestExecutor(certificate).post(redpacket.getTotalNum() > 1 ? this.getRequestUri("groupredpack_send_uri") : this.getRequestUri("redpack_send_uri"), param);
        }
        finally {
            if (certificate != null) {
                try {
                    certificate.close();
                }
                catch (IOException e) {}
            }
        }
        String text = response.getAsString().replaceFirst("<wxappid>", "<appid>").replaceFirst("</wxappid>", "</appid>");
        return XmlStream.fromXML(text, RedpacketSendResult.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RedpacketRecord queryRedpack(InputStream certificate, String outTradeNo) throws WeixinException {
        Map<String, String> para = this.createBaseRequestMap(null);
        para.put("bill_type", "MCHT");
        para.put("mch_billno", outTradeNo);
        para.put("sign", this.weixinSignature.sign(para));
        String param = XmlStream.map2xml(para);
        WeixinResponse response = null;
        try {
            response = this.createSSLRequestExecutor(certificate).post(this.getRequestUri("redpack_query_uri"), param);
        }
        finally {
            if (certificate != null) {
                try {
                    certificate.close();
                }
                catch (IOException e) {}
            }
        }
        return response.getAsObject(new TypeReference<RedpacketRecord>(){});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CorpPaymentResult sendCorpPayment(InputStream certificate, CorpPayment payment) throws WeixinException {
        payment.declareWeixinPayAccount(this.weixinAccount);
        JSONObject obj = (JSONObject)JSON.toJSON((Object)payment);
        obj.put("mchid", obj.remove((Object)"mch_id"));
        obj.put("mch_appid", obj.remove((Object)"appid"));
        obj.put("sign", (Object)this.weixinSignature.sign(obj));
        String param = XmlStream.map2xml(obj);
        WeixinResponse response = null;
        try {
            response = this.createSSLRequestExecutor(certificate).post(this.getRequestUri("corppayment_send_uri"), param);
        }
        finally {
            if (certificate != null) {
                try {
                    certificate.close();
                }
                catch (IOException e) {}
            }
        }
        String text = response.getAsString().replaceFirst("<mch_appid>", "<appid>").replaceFirst("</mch_appid>", "</appid>").replaceFirst("<mchid>", "<mch_id>").replaceFirst("</mchid>", "</mch_id>");
        return XmlStream.fromXML(text, CorpPaymentResult.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CorpPaymentRecord queryCorpPayment(InputStream certificate, String outTradeNo) throws WeixinException {
        JSONObject obj = new JSONObject();
        obj.put("nonce_str", (Object)RandomUtil.generateString(16));
        obj.put("mch_id", (Object)this.weixinAccount.getMchId());
        obj.put("appid", (Object)this.weixinAccount.getId());
        obj.put("partner_trade_no", (Object)outTradeNo);
        obj.put("sign", (Object)this.weixinSignature.sign(obj));
        String param = XmlStream.map2xml(obj);
        WeixinResponse response = null;
        try {
            response = this.createSSLRequestExecutor(certificate).post(this.getRequestUri("corppayment_query_uri"), param);
        }
        finally {
            if (certificate != null) {
                try {
                    certificate.close();
                }
                catch (IOException e) {}
            }
        }
        return response.getAsObject(new TypeReference<CorpPaymentRecord>(){});
    }

    public SettlementRecord querySettlement(boolean status, Pageable pageable, Date start, Date end) throws WeixinException {
        JSONObject obj = new JSONObject();
        obj.put("nonce_str", (Object)RandomUtil.generateString(16));
        obj.put("mch_id", (Object)this.weixinAccount.getMchId());
        obj.put("appid", (Object)this.weixinAccount.getId());
        obj.put("usetag", (Object)(status ? 1 : 2));
        obj.put("offset", (Object)pageable.getOffset());
        obj.put("limit", (Object)pageable.getPageSize());
        if (start != null) {
            obj.put("date_start", (Object)DateUtil.fortmat2yyyyMMdd(start));
        }
        if (end != null) {
            obj.put("date_end", (Object)DateUtil.fortmat2yyyyMMdd(end));
        }
        obj.put("sign", (Object)this.weixinSignature.sign(obj));
        String param = XmlStream.map2xml(obj);
        WeixinResponse response = this.weixinExecutor.post(this.getRequestUri("settlement_query_uri"), param);
        return response.getAsObject(new TypeReference<SettlementRecord>(){});
    }

    public double queryExchageRate(CurrencyType currencyType, Date date) throws WeixinException {
        if (date == null) {
            date = new Date();
        }
        JSONObject obj = new JSONObject();
        obj.put("mch_id", (Object)this.weixinAccount.getMchId());
        obj.put("appid", (Object)this.weixinAccount.getId());
        obj.put("sub_mch_id", (Object)this.weixinAccount.getSubMchId());
        obj.put("fee_type", (Object)currencyType.name());
        obj.put("date", (Object)DateUtil.fortmat2yyyyMMdd(date));
        obj.put("sign", (Object)this.weixinSignature.sign(obj));
        String param = XmlStream.map2xml(obj);
        WeixinResponse response = this.weixinExecutor.post(this.getRequestUri("exchagerate_query_uri"), param);
        BigDecimal rate = new BigDecimal(XmlStream.xml2map(response.getAsString()).get("rate"));
        return rate.divide(new BigDecimal(1.0E8)).doubleValue();
    }
}

