/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.exception;

import com.foxinmy.weixin4j.util.StringUtil;
import com.foxinmy.weixin4j.util.WeixinErrorUtil;

public class WeixinException
extends Exception {
    private static final long serialVersionUID = 7148145661883468514L;
    private String code;
    private String desc;

    public WeixinException(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public WeixinException(String desc) {
        this.code = "-1";
        this.desc = desc;
    }

    public WeixinException(Throwable e) {
        super(e);
    }

    public WeixinException(String message, Throwable cause) {
        super(message, cause);
    }

    public String getErrorCode() {
        return this.code;
    }

    public String getErrorMsg() {
        return this.desc;
    }

    @Override
    public String getMessage() {
        StringBuilder buf = new StringBuilder();
        if (StringUtil.isNotBlank(this.code)) {
            buf.append(this.code);
        }
        if (StringUtil.isNotBlank(this.desc)) {
            buf.append(" >> ").append(this.desc);
        }
        if (buf.length() > 0) {
            buf.append(" >> ").append(WeixinErrorUtil.getText(this.code));
            return buf.toString();
        }
        return super.getMessage();
    }
}

