/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http.factory;

import com.foxinmy.weixin4j.http.HttpClient;
import com.foxinmy.weixin4j.http.HttpClientException;
import com.foxinmy.weixin4j.http.factory.HttpComponent3Factory;
import com.foxinmy.weixin4j.http.factory.HttpComponent4Factory;
import com.foxinmy.weixin4j.http.factory.Netty4HttpClientFactory;
import com.foxinmy.weixin4j.http.factory.SimpleHttpClientFactory;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public abstract class HttpClientFactory {
    private static volatile HttpClientFactory defaultFactory = HttpClientFactory.newDefaultFactory();

    private static HttpClientFactory newDefaultFactory() {
        HttpClientFactory f;
        try {
            f = new Netty4HttpClientFactory();
        }
        catch (Throwable e1) {
            try {
                f = new HttpComponent4Factory();
            }
            catch (Throwable e2) {
                try {
                    f = new HttpComponent3Factory();
                }
                catch (Throwable e3) {
                    f = new SimpleHttpClientFactory();
                }
            }
        }
        return f;
    }

    public static HttpClientFactory getDefaultFactory() {
        return defaultFactory;
    }

    public static void setDefaultFactory(HttpClientFactory defaultFactory) {
        if (defaultFactory == null) {
            throw new NullPointerException("defaultFactory");
        }
        HttpClientFactory.defaultFactory = defaultFactory;
    }

    public static HttpClient getInstance() {
        return HttpClientFactory.getDefaultFactory().newInstance();
    }

    public abstract HttpClient newInstance();

    public static SSLContext allowSSLContext() throws HttpClientException {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new X509TrustManager[]{HttpClientFactory.createX509TrustManager()}, new SecureRandom());
            return sslContext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new HttpClientException("Create SSLContext NoSuchAlgorithmException:", e);
        }
        catch (KeyManagementException e) {
            throw new HttpClientException("Create SSLContext KeyManagementException:", e);
        }
    }

    protected static X509TrustManager createX509TrustManager() {
        return new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }
        };
    }
}

