/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http.factory;

import com.foxinmy.weixin4j.http.AbstractHttpResponse;
import com.foxinmy.weixin4j.http.HttpHeaders;
import com.foxinmy.weixin4j.http.HttpStatus;
import com.foxinmy.weixin4j.http.HttpVersion;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;

public class HttpComponent4_1Response
extends AbstractHttpResponse {
    private final HttpResponse httpResponse;
    private HttpHeaders headers;
    private HttpVersion protocol;
    private HttpStatus status;

    public HttpComponent4_1Response(HttpResponse httpResponse, byte[] content) throws IOException {
        super(content);
        this.httpResponse = httpResponse;
    }

    @Override
    public HttpHeaders getHeaders() {
        if (this.headers == null) {
            Header[] headers;
            this.headers = new HttpHeaders();
            for (Header header : headers = this.httpResponse.getAllHeaders()) {
                this.headers.add(header.getName(), header.getValue());
            }
        }
        return this.headers;
    }

    @Override
    public HttpVersion getProtocol() {
        if (this.protocol == null) {
            ProtocolVersion version = this.httpResponse.getProtocolVersion();
            Header connection = this.httpResponse.getFirstHeader("Connection");
            this.protocol = new HttpVersion(version.getProtocol(), version.getMajor(), version.getMinor(), connection != null && connection.getValue().equalsIgnoreCase("keep-alive"));
        }
        return this.protocol;
    }

    @Override
    public HttpStatus getStatus() {
        if (this.status == null) {
            StatusLine statusLine = this.httpResponse.getStatusLine();
            this.status = new HttpStatus(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        return this.status;
    }

    @Override
    public void close() {
        try {
            this.httpResponse.getEntity().consumeContent();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

