/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http.weixin;

import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.WeixinRequestExecutor;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;

public class WeixinSSLRequestExecutor
extends WeixinRequestExecutor {
    private final SSLContext sslContext;

    public WeixinSSLRequestExecutor(String password, InputStream inputStream) throws WeixinException {
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(inputStream, password.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(keyStore, password.toCharArray());
            this.sslContext = SSLContext.getInstance("TLS");
            this.sslContext.init(kmf.getKeyManagers(), null, new SecureRandom());
        }
        catch (Exception e) {
            throw new WeixinException("Key load error", e);
        }
        this.params.setSSLContext(this.sslContext);
    }

    public WeixinSSLRequestExecutor(SSLContext sslContext) {
        this.sslContext = sslContext;
        this.params.setSSLContext(sslContext);
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }
}

