/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.payment.mch;

import com.alibaba.fastjson.annotation.JSONField;
import com.foxinmy.weixin4j.model.WeixinPayAccount;
import com.foxinmy.weixin4j.payment.mch.MerchantResult;
import com.foxinmy.weixin4j.sign.WeixinPaymentSignature;
import com.foxinmy.weixin4j.util.RandomUtil;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class NativePayResponse
extends MerchantResult {
    private static final long serialVersionUID = 6119895998783333012L;
    @XmlElement(name="prepay_id")
    @JSONField(name="prepay_id")
    private String prepayId;

    protected NativePayResponse() {
    }

    public NativePayResponse(String returnMsg, String resultMsg) {
        super.setReturnMsg(returnMsg);
        super.setReturnCode("FAIL");
        super.setErrCodeDes(resultMsg);
        super.setResultCode("FAIL");
    }

    public NativePayResponse(WeixinPayAccount weixinAccount, String prepayId) {
        super.setReturnCode("SUCCESS");
        this.setResultCode("SUCCESS");
        this.setMchId(weixinAccount.getMchId());
        this.setAppId(weixinAccount.getId());
        this.setNonceStr(RandomUtil.generateString(16));
        this.prepayId = prepayId;
        this.setSign(new WeixinPaymentSignature(weixinAccount.getPaySignKey()).sign(this));
    }

    public String getPrepayId() {
        return this.prepayId;
    }

    @Override
    public String toString() {
        return "NativePayResponse [prepayId=" + this.prepayId + ", " + super.toString() + "]";
    }
}

