/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.payment.mch;

import com.alibaba.fastjson.annotation.JSONField;
import com.foxinmy.weixin4j.payment.mch.MerchantResult;
import com.foxinmy.weixin4j.type.CurrencyType;
import com.foxinmy.weixin4j.util.DateUtil;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;

public class SettlementRecord
extends MerchantResult {
    private static final long serialVersionUID = 7952659545609519979L;
    @XmlElement(name="fbatchno")
    @JSONField(name="fbatchno")
    private String batchNo;
    @XmlElement(name="date_settlement")
    @JSONField(name="date_settlement")
    private String settleDate;
    @XmlElement(name="date_start")
    @JSONField(name="date_start")
    private String startDate;
    @XmlElement(name="date_end")
    @JSONField(name="date_end")
    private String endDate;
    @XmlElement(name="transaction_id")
    @JSONField(name="transaction_id")
    private int settleFee;
    @XmlElement(name="unsettlement_fee")
    @JSONField(name="unsettlement_fee")
    private int unSettleFee;
    @XmlElement(name="settlementfee_type")
    @JSONField(name="settlementfee_type")
    private String settleFeeType;
    @XmlElement(name="pay_fee")
    @JSONField(name="pay_fee")
    private int payFee;
    @XmlElement(name="refund_fee")
    @JSONField(name="refund_fee")
    private int refundFee;
    @XmlElement(name="pay_net_fee")
    @JSONField(name="pay_net_fee")
    private int payNetFee;
    @XmlElement(name="poundage_fee")
    @JSONField(name="poundage_fee")
    private int poundageFee;

    protected SettlementRecord() {
    }

    public String getBatchNo() {
        return this.batchNo;
    }

    public void setBatchNo(String batchNo) {
        this.batchNo = batchNo;
    }

    public String getSettleDate() {
        return this.settleDate;
    }

    @JSONField(serialize=false)
    public Date getFormatSettleDate() {
        return DateUtil.parse2yyyyMMddHHmmss(this.settleDate);
    }

    public void setSettleDate(String settleDate) {
        this.settleDate = settleDate;
    }

    public String getStartDate() {
        return this.startDate;
    }

    @JSONField(serialize=false)
    public Date getFormatStartDate() {
        return DateUtil.parse2yyyyMMddHHmmss(this.startDate);
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    @JSONField(serialize=false)
    public Date getFormatEndDate() {
        return DateUtil.parse2yyyyMMddHHmmss(this.settleDate);
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public int getSettleFee() {
        return this.settleFee;
    }

    @JSONField(serialize=false)
    public double getFormatSettleFee() {
        return (double)this.settleFee / 100.0;
    }

    public void setSettleFee(int settleFee) {
        this.settleFee = settleFee;
    }

    public int getUnSettleFee() {
        return this.unSettleFee;
    }

    @JSONField(serialize=false)
    public double getFormatUnSettleFee() {
        return (double)this.unSettleFee / 100.0;
    }

    public void setUnSettleFee(int unSettleFee) {
        this.unSettleFee = unSettleFee;
    }

    public String getSettleFeeType() {
        return this.settleFeeType;
    }

    @JSONField(serialize=false)
    public CurrencyType getFormatSettleFeeType() {
        return CurrencyType.valueOf(this.settleFeeType.toUpperCase());
    }

    public void setSettleFeeType(String settleFeeType) {
        this.settleFeeType = settleFeeType;
    }

    public int getPayFee() {
        return this.payFee;
    }

    @JSONField(serialize=false)
    public double getFormatPayFee() {
        return (double)this.payFee / 100.0;
    }

    public void setPayFee(int payFee) {
        this.payFee = payFee;
    }

    public int getRefundFee() {
        return this.refundFee;
    }

    @JSONField(serialize=false)
    public double getFormatRefundFee() {
        return (double)this.refundFee / 100.0;
    }

    public void setRefundFee(int refundFee) {
        this.refundFee = refundFee;
    }

    public int getPayNetFee() {
        return this.payNetFee;
    }

    public void setPayNetFee(int payNetFee) {
        this.payNetFee = payNetFee;
    }

    @JSONField(serialize=false)
    public double getFormatPayNetFee() {
        return (double)this.payNetFee / 100.0;
    }

    public int getPoundageFee() {
        return this.poundageFee;
    }

    @JSONField(serialize=false)
    public double getFormatPoundageFee() {
        return (double)this.poundageFee / 100.0;
    }

    public void setPoundageFee(int poundageFee) {
        this.poundageFee = poundageFee;
    }

    @Override
    public String toString() {
        return "SettlementRecord [batchNo=" + this.batchNo + ", settleDate=" + this.settleDate + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", settleFee=" + this.settleFee + ", unSettleFee=" + this.unSettleFee + ", settleFeeType=" + this.settleFeeType + ", payFee=" + this.payFee + ", refundFee=" + this.refundFee + ", payNetFee=" + this.payNetFee + ", poundageFee=" + this.poundageFee + ", " + super.toString() + "]";
    }
}

