/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.token;

import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.token.TokenStorager;
import com.foxinmy.weixin4j.util.FileUtil;
import com.foxinmy.weixin4j.xml.XmlStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileTokenStorager
implements TokenStorager {
    private final String cachePath;

    public FileTokenStorager(String cachePath) {
        this.cachePath = cachePath;
    }

    @Override
    public Token lookup(String cacheKey) throws WeixinException {
        File token_file = new File(String.format("%s/%s.xml", this.cachePath, cacheKey));
        try {
            if (token_file.exists()) {
                Token token = XmlStream.fromXML(new FileInputStream(token_file), Token.class);
                if (token.getCreateTime() < 0L) {
                    return token;
                }
                if (token.getCreateTime() + (long)token.getExpiresIn() * 1000L - 60000L > System.currentTimeMillis()) {
                    return token;
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new WeixinException(e);
        }
    }

    @Override
    public void caching(String cacheKey, Token token) throws WeixinException {
        try {
            XmlStream.toXML(token, new FileOutputStream(new File(String.format("%s/%s.xml", this.cachePath, cacheKey))));
        }
        catch (IOException e) {
            throw new WeixinException(e);
        }
    }

    @Override
    public Token evict(String cacheKey) throws WeixinException {
        Token token = null;
        File token_file = new File(String.format("%s/%s.xml", this.cachePath, cacheKey));
        try {
            if (token_file.exists()) {
                token = XmlStream.fromXML(new FileInputStream(token_file), Token.class);
                token_file.delete();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return token;
    }

    @Override
    public void clear() throws WeixinException {
        File[] files;
        for (File token : files = new File(this.cachePath).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().startsWith("weixin4j_") && "xml".equals(FileUtil.getFileExtension(file.getName()));
            }
        })) {
            token.delete();
        }
    }
}

