/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.xml;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.NameFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.foxinmy.weixin4j.model.Consts;
import com.foxinmy.weixin4j.util.StringUtil;
import com.foxinmy.weixin4j.xml.ListsuffixResultDeserializer;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ListsuffixResultSerializer {
    public static JSONObject serializeToJSON(Object object) {
        JSONObject result = (JSONObject)JSON.toJSON((Object)object);
        Map<Field, String[]> listsuffixFields = ListsuffixResultDeserializer.getListsuffixFields(object.getClass());
        if (!listsuffixFields.isEmpty()) {
            JSONField jsonField = null;
            Object value = null;
            for (Field field : listsuffixFields.keySet()) {
                jsonField = field.getAnnotation(JSONField.class);
                if (jsonField != null && StringUtil.isNotBlank(jsonField.name())) {
                    result.remove((Object)jsonField.name());
                } else {
                    result.remove((Object)field.getName());
                }
                try {
                    field.setAccessible(true);
                    value = field.get(object);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (value == null || !(value instanceof List)) continue;
                result.putAll(ListsuffixResultSerializer.listsuffixConvertMap((List)value));
            }
        }
        return result;
    }

    public static Map<String, String> listsuffixConvertMap(List<?> listsuffix) {
        HashMap<String, String> listMap = new HashMap<String, String>();
        if (listsuffix != null && !listsuffix.isEmpty()) {
            for (int i = 0; i < listsuffix.size(); ++i) {
                listMap.putAll((Map)JSON.parseObject((String)JSON.toJSONString(listsuffix.get(i), (SerializeFilter)new ListsuffixEndNameFilter(i), (SerializerFeature[])new SerializerFeature[0]), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]));
            }
        }
        return listMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String serializeToXML(Object object) {
        JSONObject obj = ListsuffixResultSerializer.serializeToJSON(object);
        StringWriter sw = new StringWriter();
        XMLStreamWriter xw = null;
        try {
            xw = XMLOutputFactory.newInstance().createXMLStreamWriter(sw);
            xw.writeStartDocument(Consts.UTF_8.name(), "1.0");
            xw.writeStartElement("xml");
            for (String key : obj.keySet()) {
                if (StringUtil.isBlank(obj.getString(key))) continue;
                xw.writeStartElement(key);
                xw.writeCData(obj.getString(key));
                xw.writeEndElement();
            }
            xw.writeEndElement();
            xw.writeEndDocument();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        finally {
            if (xw != null) {
                try {
                    xw.close();
                }
                catch (XMLStreamException e) {}
            }
            try {
                sw.close();
            }
            catch (IOException e) {}
        }
        return sw.getBuffer().toString();
    }

    private static class ListsuffixEndNameFilter
    implements NameFilter {
        private final int index;

        public ListsuffixEndNameFilter(int index) {
            this.index = index;
        }

        public String process(Object object, String name, Object value) {
            return String.format("%s_%d", name, this.index);
        }
    }
}

