/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.expansion.handler.codec.http;

import com.gettyio.core.buffer.AutoByteBuffer;
import com.gettyio.core.logging.InternalLogger;
import com.gettyio.core.logging.InternalLoggerFactory;
import com.gettyio.expansion.handler.codec.http.FieldItem;
import com.gettyio.expansion.handler.codec.http.HttpException;
import com.gettyio.expansion.handler.codec.http.HttpHeaders;
import com.gettyio.expansion.handler.codec.http.HttpMethod;
import com.gettyio.expansion.handler.codec.http.HttpRequest;
import com.gettyio.expansion.handler.codec.http.HttpResponse;
import com.gettyio.expansion.handler.codec.http.HttpResponseStatus;
import com.gettyio.expansion.handler.codec.http.HttpVersion;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

public class HttpDecodeSerializer {
    protected static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(HttpDecodeSerializer.class);
    public static final int READLINE = 1;
    public static final int READHEADERS = 2;
    public static final int READCONTENT = 3;

    public static boolean readRequestLine(AutoByteBuffer autoByteBuffer, HttpRequest request) throws HttpException, AutoByteBuffer.ByteBufferException, UnsupportedEncodingException {
        int position;
        StringBuilder sb = new StringBuilder(64);
        int lineLength = 0;
        int limit = autoByteBuffer.writerIndex();
        for (int index = position = autoByteBuffer.readerIndex(); index < limit; ++index) {
            byte nextByte = autoByteBuffer.read(index);
            if (nextByte == 13) {
                nextByte = autoByteBuffer.read(index + 1);
                if (nextByte != 10) continue;
                autoByteBuffer.readerIndex(index + 2);
                HttpDecodeSerializer.decodeQueryString(sb.toString(), request);
                return true;
            }
            if (nextByte == 10) {
                autoByteBuffer.readerIndex(index + 2);
                HttpDecodeSerializer.decodeQueryString(sb.toString(), request);
                return true;
            }
            if (lineLength >= autoByteBuffer.writerIndex()) {
                throw new HttpException(HttpResponseStatus.REQUEST_URI_TOO_LONG, "An HTTP line is larger than " + autoByteBuffer.writerIndex() + " bytes.");
            }
            ++lineLength;
            sb.append((char)nextByte);
        }
        return false;
    }

    public static boolean readResponseLine(AutoByteBuffer autoByteBuffer, HttpResponse response) throws HttpException, AutoByteBuffer.ByteBufferException, UnsupportedEncodingException {
        int position;
        StringBuilder sb = new StringBuilder(64);
        int lineLength = 0;
        int limit = autoByteBuffer.writerIndex();
        for (int index = position = autoByteBuffer.readerIndex(); index < limit; ++index) {
            byte nextByte = autoByteBuffer.read(index);
            if (nextByte == 13) {
                nextByte = autoByteBuffer.read(index + 1);
                if (nextByte != 10) continue;
                autoByteBuffer.readerIndex(index + 2);
                HttpDecodeSerializer.decodeResponseLine(sb.toString(), response);
                return true;
            }
            if (nextByte == 10) {
                autoByteBuffer.readerIndex(index + 2);
                HttpDecodeSerializer.decodeResponseLine(sb.toString(), response);
                return true;
            }
            if (lineLength >= autoByteBuffer.writerIndex()) {
                throw new HttpException(HttpResponseStatus.REQUEST_URI_TOO_LONG, "An HTTP line is larger than " + autoByteBuffer.writerIndex() + " bytes.");
            }
            ++lineLength;
            sb.append((char)nextByte);
        }
        return false;
    }

    private static void decodeResponseLine(String requestLine, HttpResponse response) throws UnsupportedEncodingException {
        String[] requestLineArray = requestLine.split(" ");
        if (requestLineArray.length < 2) {
            throw new UnsupportedEncodingException("Wrong Request-Line format: " + requestLine);
        }
        response.setHttpVersion(HttpVersion.valueOf(requestLineArray[0]));
        HttpResponseStatus responseStatus = HttpResponseStatus.valueOf(Integer.valueOf(requestLineArray[1]));
        response.setHttpResponseStatus(responseStatus);
    }

    private static void decodeQueryString(String requestLine, HttpRequest request) throws UnsupportedEncodingException {
        String[] requestLineArray = requestLine.split(" ");
        if (requestLineArray.length < 2) {
            throw new UnsupportedEncodingException("Wrong Request-Line format: " + requestLine);
        }
        request.setHttpMethod(HttpMethod.valueOf(requestLineArray[0]));
        request.setRequestUri(requestLineArray[1]);
        request.setHttpVersion(HttpVersion.valueOf(requestLineArray[2]));
        String uri = requestLineArray[1];
        int at = uri.indexOf(63);
        String queryString = uri;
        if (at > 0) {
            queryString = uri.substring(0, at);
            String params = uri.substring(at);
            HttpDecodeSerializer.decodeParamsFromUri(params, request);
        }
        request.setQueryString(queryString);
    }

    public static void decodeParamsFromUri(String params, HttpRequest request) throws UnsupportedEncodingException {
        int start;
        String charset = "UTF-8";
        int length = params.length();
        for (start = 0; start < length && '?' == params.charAt(start); ++start) {
        }
        int left = start;
        int middle = 0;
        while (start < length) {
            if ('=' == params.charAt(start)) {
                middle = start;
                while (start < length) {
                    char c = params.charAt(start);
                    if ('&' == c) {
                        String key = params.substring(left, middle);
                        String value = params.substring(middle + 1, start);
                        request.addParameter(URLDecoder.decode(key, charset), URLDecoder.decode(value, charset));
                        while (start < length && '&' == params.charAt(start)) {
                            ++start;
                        }
                        left = start;
                        break;
                    }
                    ++start;
                }
            }
            ++start;
        }
        if (middle > left) {
            String key = params.substring(left, middle);
            String value = params.substring(middle + 1);
            request.addParameter(URLDecoder.decode(key, charset), URLDecoder.decode(value, charset));
        }
    }

    public static boolean readHeaders(AutoByteBuffer buffer, HttpRequest request) throws HttpException, AutoByteBuffer.ByteBufferException {
        StringBuilder sb = new StringBuilder(64);
        int limit = buffer.writerIndex();
        int position = buffer.readerIndex();
        int lineLength = 0;
        for (int index = position; index < limit; ++index) {
            byte nextByte = buffer.read(index);
            if (nextByte == 13) {
                nextByte = buffer.read(index + 1);
                if (nextByte != 10) continue;
                buffer.readerIndex(index);
                if (lineLength == 0) {
                    buffer.readerIndex(index + 2);
                    return true;
                }
                buffer.readerIndex(index);
                HttpDecodeSerializer.readHeader(request, sb.toString());
                lineLength = 0;
                sb.setLength(0);
                ++index;
                continue;
            }
            if (nextByte == 10) {
                if (lineLength == 0) {
                    buffer.readerIndex(index + 2);
                    return true;
                }
                buffer.readerIndex(index);
                HttpDecodeSerializer.readHeader(request, sb.toString());
                lineLength = 0;
                sb.setLength(0);
                ++index;
                continue;
            }
            if (lineLength >= buffer.writerIndex()) {
                throw new HttpException(HttpResponseStatus.BAD_REQUEST, "An HTTP header is larger than " + buffer.writerIndex() + " bytes.");
            }
            ++lineLength;
            sb.append((char)nextByte);
        }
        return false;
    }

    public static boolean readHeaders(AutoByteBuffer buffer, HttpResponse response) throws HttpException, AutoByteBuffer.ByteBufferException {
        StringBuilder sb = new StringBuilder(64);
        int limit = buffer.writerIndex();
        int position = buffer.readerIndex();
        int lineLength = 0;
        for (int index = position; index < limit; ++index) {
            byte nextByte = buffer.read(index);
            if (nextByte == 13) {
                nextByte = buffer.read(index + 1);
                if (nextByte != 10) continue;
                buffer.readerIndex(index);
                if (lineLength == 0) {
                    buffer.readerIndex(index + 2);
                    return true;
                }
                buffer.readerIndex(index);
                HttpDecodeSerializer.readHeader(response, sb.toString());
                lineLength = 0;
                sb.setLength(0);
                ++index;
                continue;
            }
            if (nextByte == 10) {
                if (lineLength == 0) {
                    buffer.readerIndex(index + 2);
                    return true;
                }
                buffer.readerIndex(index);
                HttpDecodeSerializer.readHeader(response, sb.toString());
                lineLength = 0;
                sb.setLength(0);
                ++index;
                continue;
            }
            if (lineLength >= buffer.writerIndex()) {
                throw new HttpException(HttpResponseStatus.BAD_REQUEST, "An HTTP header is larger than " + buffer.writerIndex() + " bytes.");
            }
            ++lineLength;
            sb.append((char)nextByte);
        }
        return false;
    }

    private static void readHeader(HttpRequest request, String header) {
        String[] kv = HttpDecodeSerializer.splitHeader(header);
        request.addHeader(kv[0], kv[1]);
    }

    private static void readHeader(HttpResponse response, String header) {
        String[] kv = HttpDecodeSerializer.splitHeader(header);
        response.addHeader(kv[0], kv[1]);
    }

    private static String[] splitHeader(String sb) {
        int valueStart;
        int colonEnd;
        int nameStart;
        char ch;
        int nameEnd;
        int length = sb.length();
        for (nameEnd = nameStart = HttpDecodeSerializer.findNonWhitespace(sb, 0); nameEnd < length && (ch = sb.charAt(nameEnd)) != ':' && !Character.isWhitespace(ch); ++nameEnd) {
        }
        for (colonEnd = nameEnd; colonEnd < length; ++colonEnd) {
            if (sb.charAt(colonEnd) != ':') continue;
            ++colonEnd;
            break;
        }
        if ((valueStart = HttpDecodeSerializer.findNonWhitespace(sb, colonEnd)) == length) {
            return new String[]{sb.substring(nameStart, nameEnd), ""};
        }
        int valueEnd = HttpDecodeSerializer.findEndOfString(sb);
        return new String[]{sb.substring(nameStart, nameEnd), sb.substring(valueStart, valueEnd)};
    }

    public static boolean readContent(AutoByteBuffer buffer, HttpRequest request) throws Exception {
        long contentLength = HttpHeaders.getContentLength(request);
        if (contentLength <= 0L) {
            return true;
        }
        int remain = buffer.readableBytes();
        if ((long)remain < contentLength) {
            return false;
        }
        request.getHttpBody().setContentLength(contentLength);
        String contentType = request.getHeader("Content-Type");
        request.getHttpBody().setContentType(contentType);
        byte[] bytes = new byte[Long.valueOf(contentLength).intValue()];
        buffer.readBytes(bytes);
        request.getHttpBody().setContent(bytes);
        if (request.getHttpBody().getContentType().contains("multipart/")) {
            HttpDecodeSerializer.readMultipart(request);
        } else {
            HttpDecodeSerializer.decodeParamsFromUri(new String(request.getHttpBody().getContent()), request);
        }
        return true;
    }

    public static boolean readContent(AutoByteBuffer buffer, HttpResponse response) throws Exception {
        long contentLength = HttpHeaders.getContentLength(response);
        if (contentLength <= 0L) {
            return true;
        }
        int remain = buffer.readableBytes();
        if ((long)remain < contentLength) {
            return false;
        }
        response.getHttpBody().setContentLength(contentLength);
        String contentType = response.getHeader("Content-Type");
        response.getHttpBody().setContentType(contentType);
        byte[] bytes = new byte[Long.valueOf(contentLength).intValue()];
        buffer.readBytes(bytes);
        response.getHttpBody().setContent(bytes);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean readMultipart(HttpRequest request) {
        indexOfBoundary = request.getHttpBody().getContentType().indexOf("boundary=");
        if (indexOfBoundary == -1) {
            throw new NullPointerException("boundary is null");
        }
        boundary = request.getHttpBody().getContentType().substring(indexOfBoundary);
        boundary = "--" + HttpDecodeSerializer.getSubAttribute(boundary, "boundary");
        endBoundary = boundary + "--";
        content = request.getHttpBody().getContent();
        contentLength = request.getHttpBody().getContentLength();
        step = Step.BOUNDARY;
        autoByteBuffer = AutoByteBuffer.newByteBuffer();
        bodyBuffer = AutoByteBuffer.newByteBuffer();
        fileItem = null;
        headers = new HashMap<String, String>();
        index = 0;
        while ((long)index < contentLength) {
            nextByte = content[index];
            if (nextByte != 13 || (nextByte = content[++index]) != 10) ** GOTO lbl-1000
            switch (1.$SwitchMap$com$gettyio$expansion$handler$codec$http$HttpDecodeSerializer$Step[step.ordinal()]) {
                case 1: {
                    line = new String(autoByteBuffer.readableBytesArray());
                    if (!line.equals(boundary)) break;
                    step = Step.HEADER;
                    fileItem = new FieldItem();
                    autoByteBuffer.clear();
                    break;
                }
                case 2: {
                    map = HttpDecodeSerializer.getKeyValueAttribute(new String(autoByteBuffer.readableBytesArray()));
                    headers.putAll(map);
                    fileItem.setContentDisposition((String)headers.get("Content-Disposition".toLowerCase()));
                    fileItem.setContentType((String)headers.get("Content-Type".toLowerCase()));
                    name = (String)headers.get("name");
                    fileItem.setName(name);
                    name = (String)headers.get("filename");
                    if (name != null) {
                        fileItem.setFilename(name);
                        fileItem.setFormField(false);
                    }
                    if ((nextByte = content[index + 1]) == 13 && (nextByte = content[++index + 1]) == 10) {
                        ++index;
                        step = Step.BODY;
                    }
                    autoByteBuffer.clear();
                    break;
                }
                case 3: {
                    body = new String(autoByteBuffer.readableBytesArray());
                    if (body.equals(endBoundary)) {
                        step = Step.END;
                        if (fileItem.isFormField()) {
                            v = new String(bodyBuffer.readableBytesArray());
                            request.addParameter(fileItem.getName(), v);
                            fileItem.setValue(v);
                        } else {
                            fileItem.setFile(bodyBuffer.readableBytesArray());
                        }
                        request.addFieldItem(fileItem.getName(), fileItem);
                        return true;
                    }
                    if (body.equals(boundary)) {
                        step = Step.HEADER;
                        if (fileItem.isFormField()) {
                            v = new String(bodyBuffer.readableBytesArray());
                            request.addParameter(fileItem.getName(), v);
                            fileItem.setValue(v);
                        } else {
                            fileItem.setFile(bodyBuffer.readableBytesArray());
                        }
                        request.addFieldItem(fileItem.getName(), fileItem);
                        fileItem = new FieldItem();
                        headers.clear();
                        autoByteBuffer.clear();
                        bodyBuffer.clear();
                        break;
                    }
                    bodyBuffer.writeBytes(autoByteBuffer);
                    autoByteBuffer.clear();
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    autoByteBuffer.writeByte(nextByte);
                }
            }
            ++index;
        }
        return false;
    }

    private static int findNonWhitespace(String sb, int offset) {
        int result;
        for (result = offset; result < sb.length() && Character.isWhitespace(sb.charAt(result)); ++result) {
        }
        return result;
    }

    private static int findWhitespace(String sb, int offset) {
        int result;
        for (result = offset; result < sb.length() && !Character.isWhitespace(sb.charAt(result)); ++result) {
        }
        return result;
    }

    private static int findEndOfString(String sb) {
        int result;
        for (result = sb.length(); result > 0 && Character.isWhitespace(sb.charAt(result - 1)); --result) {
        }
        return result;
    }

    public static String getSubAttribute(String str, String name) {
        char charAt;
        int index = str.indexOf(name + "=");
        if (index == -1 && (index = str.indexOf(name + ":")) == -1) {
            return null;
        }
        int startIndex = index + 1 + name.length();
        char[] c = new char[str.length() - startIndex];
        for (int i = 0; i < c.length && (charAt = str.charAt(i + startIndex)) != ';'; ++i) {
            c[i] = charAt;
        }
        return new String(c).replaceAll("['\"]", "");
    }

    public static Map<String, String> getKeyValueAttribute(String str) {
        String[] strings;
        int index = str.indexOf(":");
        int index2 = str.indexOf("=");
        if (index == -1 && index2 == -1) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s : strings = str.split(";")) {
            String[] arr;
            if (s.contains(":")) {
                arr = s.split(":");
                map.put(arr[0].toLowerCase().trim().replaceAll("['\"]", ""), arr[1].trim().replaceAll("['\"]", ""));
                continue;
            }
            if (!s.contains("=")) continue;
            arr = s.split("=");
            map.put(arr[0].toLowerCase().trim().replaceAll("['\"]", ""), arr[1].trim().replaceAll("['\"]", ""));
        }
        return map;
    }

    public static enum Step {
        BOUNDARY,
        HEADER,
        BODY,
        END;

    }
}

