/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.expansion.handler.codec.mqtt;

import com.gettyio.core.buffer.AutoByteBuffer;
import com.gettyio.core.channel.SocketChannel;
import com.gettyio.core.handler.codec.DecoderException;
import com.gettyio.core.handler.codec.MessageToByteEncoder;
import com.gettyio.core.util.CharsetUtil;
import com.gettyio.expansion.handler.codec.mqtt.MqttCodecUtil;
import com.gettyio.expansion.handler.codec.mqtt.MqttConnAckMessage;
import com.gettyio.expansion.handler.codec.mqtt.MqttConnectMessage;
import com.gettyio.expansion.handler.codec.mqtt.MqttConnectPayload;
import com.gettyio.expansion.handler.codec.mqtt.MqttConnectVariableHeader;
import com.gettyio.expansion.handler.codec.mqtt.MqttFixedHeader;
import com.gettyio.expansion.handler.codec.mqtt.MqttIdentifierRejectedException;
import com.gettyio.expansion.handler.codec.mqtt.MqttMessage;
import com.gettyio.expansion.handler.codec.mqtt.MqttMessageIdVariableHeader;
import com.gettyio.expansion.handler.codec.mqtt.MqttPublishMessage;
import com.gettyio.expansion.handler.codec.mqtt.MqttPublishVariableHeader;
import com.gettyio.expansion.handler.codec.mqtt.MqttSubAckMessage;
import com.gettyio.expansion.handler.codec.mqtt.MqttSubscribeMessage;
import com.gettyio.expansion.handler.codec.mqtt.MqttSubscribePayload;
import com.gettyio.expansion.handler.codec.mqtt.MqttTopicSubscription;
import com.gettyio.expansion.handler.codec.mqtt.MqttUnsubscribeMessage;
import com.gettyio.expansion.handler.codec.mqtt.MqttUnsubscribePayload;
import com.gettyio.expansion.handler.codec.mqtt.MqttVersion;

public final class MqttEncoder
extends MessageToByteEncoder {
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final MqttEncoder INSTANCE = new MqttEncoder();

    private MqttEncoder() {
    }

    public void encode(SocketChannel socketChannel, Object obj) throws Exception {
        AutoByteBuffer autoByteBuffer = MqttEncoder.doEncode((MqttMessage)obj);
        super.encode(socketChannel, (Object)autoByteBuffer.array());
    }

    static AutoByteBuffer doEncode(MqttMessage message) {
        switch (message.fixedHeader().messageType()) {
            case CONNECT: {
                return MqttEncoder.encodeConnectMessage((MqttConnectMessage)message);
            }
            case CONNACK: {
                return MqttEncoder.encodeConnAckMessage((MqttConnAckMessage)message);
            }
            case PUBLISH: {
                return MqttEncoder.encodePublishMessage((MqttPublishMessage)message);
            }
            case SUBSCRIBE: {
                return MqttEncoder.encodeSubscribeMessage((MqttSubscribeMessage)message);
            }
            case UNSUBSCRIBE: {
                return MqttEncoder.encodeUnsubscribeMessage((MqttUnsubscribeMessage)message);
            }
            case SUBACK: {
                return MqttEncoder.encodeSubAckMessage((MqttSubAckMessage)message);
            }
            case UNSUBACK: 
            case PUBACK: 
            case PUBREC: 
            case PUBREL: 
            case PUBCOMP: {
                return MqttEncoder.encodeMessageWithOnlySingleByteFixedHeaderAndMessageId(message);
            }
            case PINGREQ: 
            case PINGRESP: 
            case DISCONNECT: {
                return MqttEncoder.encodeMessageWithOnlySingleByteFixedHeader(message);
            }
        }
        throw new IllegalArgumentException("Unknown message type: " + message.fixedHeader().messageType().value());
    }

    private static AutoByteBuffer encodeConnectMessage(MqttConnectMessage message) {
        byte[] password;
        byte[] passwordBytes;
        String userName;
        byte[] userNameBytes;
        byte[] willMessageBytes;
        int payloadBufferSize = 0;
        MqttFixedHeader mqttFixedHeader = message.fixedHeader();
        MqttConnectVariableHeader variableHeader = message.variableHeader();
        MqttConnectPayload payload = message.payload();
        MqttVersion mqttVersion = MqttVersion.fromProtocolNameAndLevel(variableHeader.name(), (byte)variableHeader.version());
        if (!variableHeader.hasUserName() && variableHeader.hasPassword()) {
            throw new DecoderException("Without a username, the password MUST be not set");
        }
        String clientIdentifier = payload.clientIdentifier();
        if (!MqttCodecUtil.isValidClientId(mqttVersion, clientIdentifier)) {
            throw new MqttIdentifierRejectedException("invalid clientIdentifier: " + clientIdentifier);
        }
        byte[] clientIdentifierBytes = MqttEncoder.encodeStringUtf8(clientIdentifier);
        payloadBufferSize += 2 + clientIdentifierBytes.length;
        String willTopic = payload.willTopic();
        byte[] willTopicBytes = willTopic != null ? MqttEncoder.encodeStringUtf8(willTopic) : EMPTY_BYTES;
        byte[] willMessage = payload.willMessageInBytes();
        byte[] byArray = willMessageBytes = willMessage != null ? willMessage : EMPTY_BYTES;
        if (variableHeader.isWillFlag()) {
            payloadBufferSize += 2 + willTopicBytes.length;
            payloadBufferSize += 2 + willMessageBytes.length;
        }
        byte[] byArray2 = userNameBytes = (userName = payload.userName()) != null ? MqttEncoder.encodeStringUtf8(userName) : EMPTY_BYTES;
        if (variableHeader.hasUserName()) {
            payloadBufferSize += 2 + userNameBytes.length;
        }
        byte[] byArray3 = passwordBytes = (password = payload.passwordInBytes()) != null ? password : EMPTY_BYTES;
        if (variableHeader.hasPassword()) {
            payloadBufferSize += 2 + passwordBytes.length;
        }
        byte[] protocolNameBytes = mqttVersion.protocolNameBytes();
        int variableHeaderBufferSize = 2 + protocolNameBytes.length + 4;
        int variablePartSize = variableHeaderBufferSize + payloadBufferSize;
        int fixedHeaderBufferSize = 1 + MqttEncoder.getVariableLengthInt(variablePartSize);
        AutoByteBuffer buf = AutoByteBuffer.newByteBuffer((int)(fixedHeaderBufferSize + variablePartSize));
        buf.write(MqttEncoder.getFixedHeaderByte1(mqttFixedHeader));
        MqttEncoder.writeVariableLengthInt(buf, variablePartSize);
        buf.writeShort(protocolNameBytes.length);
        buf.writeBytes(protocolNameBytes);
        buf.write(variableHeader.version());
        buf.write(MqttEncoder.getConnVariableHeaderFlag(variableHeader));
        buf.writeShort(variableHeader.keepAliveTimeSeconds());
        buf.writeShort(clientIdentifierBytes.length);
        buf.writeBytes(clientIdentifierBytes, 0, clientIdentifierBytes.length);
        if (variableHeader.isWillFlag()) {
            buf.writeShort(willTopicBytes.length);
            buf.writeBytes(willTopicBytes, 0, willTopicBytes.length);
            buf.writeShort(willMessageBytes.length);
            buf.writeBytes(willMessageBytes, 0, willMessageBytes.length);
        }
        if (variableHeader.hasUserName()) {
            buf.writeShort(userNameBytes.length);
            buf.writeBytes(userNameBytes, 0, userNameBytes.length);
        }
        if (variableHeader.hasPassword()) {
            buf.writeShort(passwordBytes.length);
            buf.writeBytes(passwordBytes, 0, passwordBytes.length);
        }
        return buf;
    }

    private static int getConnVariableHeaderFlag(MqttConnectVariableHeader variableHeader) {
        int flagByte = 0;
        if (variableHeader.hasUserName()) {
            flagByte |= 0x80;
        }
        if (variableHeader.hasPassword()) {
            flagByte |= 0x40;
        }
        if (variableHeader.isWillRetain()) {
            flagByte |= 0x20;
        }
        flagByte |= (variableHeader.willQos() & 3) << 3;
        if (variableHeader.isWillFlag()) {
            flagByte |= 4;
        }
        if (variableHeader.isCleanSession()) {
            flagByte |= 2;
        }
        return flagByte;
    }

    private static AutoByteBuffer encodeConnAckMessage(MqttConnAckMessage message) {
        AutoByteBuffer buf = AutoByteBuffer.newByteBuffer((int)4);
        buf.write(MqttEncoder.getFixedHeaderByte1(message.fixedHeader()));
        buf.write(2);
        buf.write(message.variableHeader().isSessionPresent() ? 1 : 0);
        buf.write((int)message.variableHeader().connectReturnCode().byteValue());
        return buf;
    }

    private static AutoByteBuffer encodeSubscribeMessage(MqttSubscribeMessage message) {
        int variableHeaderBufferSize = 2;
        int payloadBufferSize = 0;
        MqttFixedHeader mqttFixedHeader = message.fixedHeader();
        MqttMessageIdVariableHeader variableHeader = message.variableHeader();
        MqttSubscribePayload payload = message.payload();
        for (MqttTopicSubscription topic : payload.topicSubscriptions()) {
            String topicName = topic.topicName();
            byte[] topicNameBytes = MqttEncoder.encodeStringUtf8(topicName);
            payloadBufferSize += 2 + topicNameBytes.length;
            ++payloadBufferSize;
        }
        int variablePartSize = variableHeaderBufferSize + payloadBufferSize;
        int fixedHeaderBufferSize = 1 + MqttEncoder.getVariableLengthInt(variablePartSize);
        AutoByteBuffer buf = AutoByteBuffer.newByteBuffer((int)(fixedHeaderBufferSize + variablePartSize));
        buf.write(MqttEncoder.getFixedHeaderByte1(mqttFixedHeader));
        MqttEncoder.writeVariableLengthInt(buf, variablePartSize);
        int messageId = variableHeader.messageId();
        buf.writeShort(messageId);
        for (MqttTopicSubscription topic : payload.topicSubscriptions()) {
            String topicName = topic.topicName();
            byte[] topicNameBytes = MqttEncoder.encodeStringUtf8(topicName);
            buf.writeShort(topicNameBytes.length);
            buf.writeBytes(topicNameBytes, 0, topicNameBytes.length);
            buf.write(topic.qualityOfService().value());
        }
        return buf;
    }

    private static AutoByteBuffer encodeUnsubscribeMessage(MqttUnsubscribeMessage message) {
        int variableHeaderBufferSize = 2;
        int payloadBufferSize = 0;
        MqttFixedHeader mqttFixedHeader = message.fixedHeader();
        MqttMessageIdVariableHeader variableHeader = message.variableHeader();
        MqttUnsubscribePayload payload = message.payload();
        for (String topicName : payload.topics()) {
            byte[] topicNameBytes = MqttEncoder.encodeStringUtf8(topicName);
            payloadBufferSize += 2 + topicNameBytes.length;
        }
        int variablePartSize = variableHeaderBufferSize + payloadBufferSize;
        int fixedHeaderBufferSize = 1 + MqttEncoder.getVariableLengthInt(variablePartSize);
        AutoByteBuffer buf = AutoByteBuffer.newByteBuffer((int)(fixedHeaderBufferSize + variablePartSize));
        buf.write(MqttEncoder.getFixedHeaderByte1(mqttFixedHeader));
        MqttEncoder.writeVariableLengthInt(buf, variablePartSize);
        int messageId = variableHeader.messageId();
        buf.writeShort(messageId);
        for (String topicName : payload.topics()) {
            byte[] topicNameBytes = MqttEncoder.encodeStringUtf8(topicName);
            buf.writeShort(topicNameBytes.length);
            buf.writeBytes(topicNameBytes, 0, topicNameBytes.length);
        }
        return buf;
    }

    private static AutoByteBuffer encodeSubAckMessage(MqttSubAckMessage message) {
        int variableHeaderBufferSize = 2;
        int payloadBufferSize = message.payload().grantedQoSLevels().size();
        int variablePartSize = variableHeaderBufferSize + payloadBufferSize;
        int fixedHeaderBufferSize = 1 + MqttEncoder.getVariableLengthInt(variablePartSize);
        AutoByteBuffer buf = AutoByteBuffer.newByteBuffer((int)(fixedHeaderBufferSize + variablePartSize));
        buf.write(MqttEncoder.getFixedHeaderByte1(message.fixedHeader()));
        MqttEncoder.writeVariableLengthInt(buf, variablePartSize);
        buf.writeShort(message.variableHeader().messageId());
        for (int qos : message.payload().grantedQoSLevels()) {
            buf.write(qos);
        }
        return buf;
    }

    private static AutoByteBuffer encodePublishMessage(MqttPublishMessage message) {
        MqttFixedHeader mqttFixedHeader = message.fixedHeader();
        MqttPublishVariableHeader variableHeader = message.variableHeader();
        AutoByteBuffer payload = message.payload().duplicate();
        String topicName = variableHeader.topicName();
        byte[] topicNameBytes = MqttEncoder.encodeStringUtf8(topicName);
        int variableHeaderBufferSize = 2 + topicNameBytes.length + (mqttFixedHeader.qosLevel().value() > 0 ? 2 : 0);
        int payloadBufferSize = payload.readableBytes();
        int variablePartSize = variableHeaderBufferSize + payloadBufferSize;
        int fixedHeaderBufferSize = 1 + MqttEncoder.getVariableLengthInt(variablePartSize);
        AutoByteBuffer buf = AutoByteBuffer.newByteBuffer((int)(fixedHeaderBufferSize + variablePartSize));
        buf.write(MqttEncoder.getFixedHeaderByte1(mqttFixedHeader));
        MqttEncoder.writeVariableLengthInt(buf, variablePartSize);
        buf.writeShort(topicNameBytes.length);
        buf.writeBytes(topicNameBytes);
        if (mqttFixedHeader.qosLevel().value() > 0) {
            buf.write(variableHeader.messageId());
        }
        buf.writeBytes(payload);
        return buf;
    }

    private static AutoByteBuffer encodeMessageWithOnlySingleByteFixedHeaderAndMessageId(MqttMessage message) {
        MqttFixedHeader mqttFixedHeader = message.fixedHeader();
        MqttMessageIdVariableHeader variableHeader = (MqttMessageIdVariableHeader)message.variableHeader();
        int msgId = variableHeader.messageId();
        int variableHeaderBufferSize = 2;
        int fixedHeaderBufferSize = 1 + MqttEncoder.getVariableLengthInt(variableHeaderBufferSize);
        AutoByteBuffer buf = AutoByteBuffer.newByteBuffer((int)(fixedHeaderBufferSize + variableHeaderBufferSize));
        buf.write(MqttEncoder.getFixedHeaderByte1(mqttFixedHeader));
        MqttEncoder.writeVariableLengthInt(buf, variableHeaderBufferSize);
        buf.writeShort(msgId);
        return buf;
    }

    private static AutoByteBuffer encodeMessageWithOnlySingleByteFixedHeader(MqttMessage message) {
        MqttFixedHeader mqttFixedHeader = message.fixedHeader();
        AutoByteBuffer buf = AutoByteBuffer.newByteBuffer((int)2);
        buf.write(MqttEncoder.getFixedHeaderByte1(mqttFixedHeader));
        buf.write(0);
        return buf;
    }

    private static int getFixedHeaderByte1(MqttFixedHeader header) {
        int ret = 0;
        ret |= header.messageType().value() << 4;
        if (header.isDup()) {
            ret |= 8;
        }
        ret |= header.qosLevel().value() << 1;
        if (header.isRetain()) {
            ret |= 1;
        }
        return ret;
    }

    private static void writeVariableLengthInt(AutoByteBuffer buf, int num) {
        do {
            int digit = num % 128;
            if ((num /= 128) > 0) {
                digit |= 0x80;
            }
            buf.write(digit);
        } while (num > 0);
    }

    private static int getVariableLengthInt(int num) {
        int count = 0;
        do {
            ++count;
        } while ((num /= 128) > 0);
        return count;
    }

    private static byte[] encodeStringUtf8(String s) {
        return s.getBytes(CharsetUtil.UTF_8);
    }
}

