/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.expansion.handler.codec.mqtt;

import com.gettyio.core.util.CharsetUtil;
import com.gettyio.core.util.ObjectUtil;
import com.gettyio.expansion.handler.codec.mqtt.MqttUnacceptableProtocolVersionException;

public enum MqttVersion {
    MQTT_3_1("MQIsdp", 3),
    MQTT_3_1_1("MQTT", 4);

    private final String name;
    private final byte level;

    private MqttVersion(String protocolName, byte protocolLevel) {
        this.name = (String)ObjectUtil.checkNotNull((Object)protocolName, (String)"protocolName");
        this.level = protocolLevel;
    }

    public String protocolName() {
        return this.name;
    }

    public byte[] protocolNameBytes() {
        return this.name.getBytes(CharsetUtil.UTF_8);
    }

    public byte protocolLevel() {
        return this.level;
    }

    public static MqttVersion fromProtocolNameAndLevel(String protocolName, byte protocolLevel) {
        for (MqttVersion mv : MqttVersion.values()) {
            if (!mv.name.equals(protocolName)) continue;
            if (mv.level == protocolLevel) {
                return mv;
            }
            throw new MqttUnacceptableProtocolVersionException(protocolName + " and " + protocolLevel + " are not match");
        }
        throw new MqttUnacceptableProtocolVersionException(protocolName + "is unknown protocol name");
    }
}

