/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.expansion.handler.codec.protobuf;

import com.gettyio.core.buffer.AutoByteBuffer;
import com.gettyio.core.channel.SocketChannel;
import com.gettyio.core.handler.codec.ObjectToMessageDecoder;
import com.gettyio.core.util.LinkedNonReadBlockQueue;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;

public class ProtobufDecoder
extends ObjectToMessageDecoder {
    private static final boolean HAS_PARSER;
    private final MessageLite prototype;
    private final ExtensionRegistryLite extensionRegistry;

    public ProtobufDecoder(MessageLite prototype) {
        this(prototype, (ExtensionRegistry)null);
    }

    public ProtobufDecoder(MessageLite prototype, ExtensionRegistry extensionRegistry) {
        this(prototype, (ExtensionRegistryLite)extensionRegistry);
    }

    public ProtobufDecoder(MessageLite prototype, ExtensionRegistryLite extensionRegistry) {
        if (prototype == null) {
            throw new NullPointerException("prototype");
        }
        this.prototype = prototype.getDefaultInstanceForType();
        this.extensionRegistry = extensionRegistry;
    }

    public void decode(SocketChannel socketChannel, Object obj, LinkedNonReadBlockQueue<Object> out) throws Exception {
        MessageLite messageLite;
        block8: {
            byte[] bytes = (byte[])obj;
            AutoByteBuffer msg = AutoByteBuffer.newByteBuffer((int)bytes.length);
            msg.writeBytes(bytes);
            int length = msg.readableBytes();
            if (!msg.hasRemaining()) {
                return;
            }
            byte[] array = msg.array();
            int offset = msg.readerIndex();
            messageLite = null;
            if (this.extensionRegistry == null) {
                try {
                    if (HAS_PARSER) {
                        messageLite = (MessageLite)this.prototype.getParserForType().parseFrom(array, offset, length);
                        break block8;
                    }
                    messageLite = this.prototype.newBuilderForType().mergeFrom(array, offset, length).build();
                }
                catch (InvalidProtocolBufferException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    messageLite = HAS_PARSER ? (MessageLite)this.prototype.getParserForType().parseFrom(array, offset, length, this.extensionRegistry) : this.prototype.newBuilderForType().mergeFrom(array, offset, length, this.extensionRegistry).build();
                }
                catch (InvalidProtocolBufferException e) {
                    e.printStackTrace();
                }
            }
        }
        out.put(messageLite);
        super.decode(socketChannel, obj, out);
    }

    static {
        boolean hasParser = false;
        try {
            MessageLite.class.getDeclaredMethod("getParserForType", new Class[0]);
            hasParser = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        HAS_PARSER = hasParser;
    }
}

