/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.expansion.handler.codec.protobuf;

import com.gettyio.core.buffer.AutoByteBuffer;
import com.gettyio.core.channel.SocketChannel;
import com.gettyio.core.handler.codec.ObjectToMessageDecoder;
import com.gettyio.core.util.LinkedNonReadBlockQueue;
import java.io.IOException;

public class ProtobufVarint32FrameDecoder
extends ObjectToMessageDecoder {
    AutoByteBuffer autoByteBuffer = AutoByteBuffer.newByteBuffer();

    public void decode(SocketChannel socketChannel, Object obj, LinkedNonReadBlockQueue<Object> out) throws Exception {
        byte[] bytes = (byte[])obj;
        this.autoByteBuffer.writeBytes(bytes);
        while (this.autoByteBuffer.hasRemaining()) {
            int preIndex = this.autoByteBuffer.readerIndex();
            int length = ProtobufVarint32FrameDecoder.readRawVarint32(this.autoByteBuffer);
            if (preIndex == this.autoByteBuffer.readerIndex()) {
                return;
            }
            if (length < 0) {
                throw new RuntimeException("negative length: " + length);
            }
            if (this.autoByteBuffer.readableBytes() < length) {
                this.autoByteBuffer.readerIndex(0);
                break;
            }
            byte[] b = new byte[length];
            this.autoByteBuffer.readBytes(b);
            this.autoByteBuffer.discardReadBytes();
            super.decode(socketChannel, (Object)b, out);
        }
    }

    private static int readRawVarint32(AutoByteBuffer buffer) throws IOException {
        if (!buffer.hasRemaining()) {
            return 0;
        }
        byte tmp = buffer.readByte();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        if (!buffer.hasRemaining()) {
            buffer.reset();
            return 0;
        }
        tmp = buffer.readByte();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            if (!buffer.hasRemaining()) {
                buffer.reset();
                return 0;
            }
            tmp = buffer.readByte();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                if (!buffer.hasRemaining()) {
                    buffer.reset();
                    return 0;
                }
                tmp = buffer.readByte();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    if (!buffer.hasRemaining()) {
                        buffer.reset();
                        return 0;
                    }
                    tmp = buffer.readByte();
                    result |= tmp << 28;
                    if (tmp < 0) {
                        throw new RuntimeException("malformed varint.");
                    }
                }
            }
        }
        return result;
    }
}

