/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.expansion.handler.codec.websocket;

import com.gettyio.core.buffer.AutoByteBuffer;
import com.gettyio.core.channel.SocketChannel;
import com.gettyio.core.handler.codec.MessageToByteEncoder;
import com.gettyio.core.util.CharsetUtil;
import com.gettyio.core.util.ObjectUtil;
import com.gettyio.expansion.handler.codec.websocket.Opcode;
import com.gettyio.expansion.handler.codec.websocket.WebSocketConstants;
import com.gettyio.expansion.handler.codec.websocket.WebSocketDecoder;
import com.gettyio.expansion.handler.codec.websocket.frame.WebSocketFrame;

public class WebSocketEncoder
extends MessageToByteEncoder {
    public void encode(SocketChannel aioChannel, Object obj) throws Exception {
        if (aioChannel.isHandShak()) {
            if (obj instanceof WebSocketFrame) {
                byte[] bytes = ((WebSocketFrame)obj).getPayloadData();
                if (Integer.valueOf(WebSocketDecoder.protocolVersion) <= 0) {
                    AutoByteBuffer autoByteBuffer = AutoByteBuffer.newByteBuffer();
                    autoByteBuffer.writeBytes(WebSocketConstants.BEGIN_MSG.getBytes(CharsetUtil.UTF_8));
                    autoByteBuffer.writeBytes(bytes);
                    autoByteBuffer.writeBytes(WebSocketConstants.END_MSG.getBytes(CharsetUtil.UTF_8));
                    obj = autoByteBuffer.array();
                } else {
                    obj = this.codeVersion6(bytes, ((WebSocketFrame)obj).getOpcode());
                }
            } else {
                byte[] bytes = ObjectUtil.ObjToByteArray((Object)obj);
                obj = this.codeVersion6(bytes, Opcode.BINARY.getCode());
            }
        }
        super.encode(aioChannel, obj);
    }

    public byte[] codeVersion6(byte[] msg, byte op) {
        AutoByteBuffer autoByteBuffer = AutoByteBuffer.newByteBuffer();
        WebSocketFrame messageFrame = new WebSocketFrame();
        messageFrame.setDateLength(msg.length);
        byte[] headers = new byte[2];
        headers[0] = -128;
        headers[0] = (byte)(headers[0] | (messageFrame.getRsv1() | messageFrame.getRsv2() | messageFrame.getRsv3() | op));
        headers[1] = 0;
        headers[1] = (byte)(headers[1] | (0 | messageFrame.getPayloadLen()));
        autoByteBuffer.writeBytes(headers);
        if (messageFrame.getPayloadLen() == 126) {
            autoByteBuffer.writeBytes(ObjectUtil.shortToByte((int)messageFrame.getPayloadLenExtended()));
        } else if (messageFrame.getPayloadLen() == 127) {
            autoByteBuffer.writeBytes(ObjectUtil.longToByte((long)messageFrame.getPayloadLenExtendedContinued()));
        }
        autoByteBuffer.writeBytes(msg);
        return autoByteBuffer.readableBytesArray();
    }
}

