/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.expansion.handler.codec.websocket.frame;

import com.gettyio.core.logging.InternalLogger;
import com.gettyio.core.logging.InternalLoggerFactory;
import com.gettyio.core.util.CharsetUtil;
import com.gettyio.expansion.handler.codec.websocket.Opcode;
import com.gettyio.expansion.handler.codec.websocket.frame.WebSocketFrame;
import java.io.UnsupportedEncodingException;

public class TextWebSocketFrame
extends WebSocketFrame {
    protected static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(TextWebSocketFrame.class);

    public TextWebSocketFrame() {
        this.setOpcode(Opcode.TEXT.getCode());
    }

    public TextWebSocketFrame(String text) {
        this.setOpcode(Opcode.TEXT.getCode());
        try {
            byte[] bytes = text.getBytes("utf-8");
            this.setPayloadData(bytes);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Throwable)e);
        }
    }

    public TextWebSocketFrame(byte[] bytes) {
        this.setOpcode(Opcode.TEXT.getCode());
        this.setPayloadData(bytes);
    }

    public String text() {
        return new String(this.getPayloadData(), CharsetUtil.UTF_8);
    }
}

