/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.expansion.handler.codec.websocket.frame;

import com.gettyio.core.buffer.AutoByteBuffer;
import com.gettyio.core.util.ObjectUtil;

public class WebSocketFrame {
    public static final byte FIN = -128;
    public static final byte RSV1 = 112;
    public static final byte RSV2 = 48;
    public static final byte RSV3 = 16;
    public static final byte OPCODE = 15;
    public static final byte MASK = -128;
    public static final byte PAYLOAD_LEN = 127;
    public static final byte HAS_EXTEND_DATA = 126;
    public static final byte HAS_EXTEND_DATA_CONTINUE = 127;
    private byte fin;
    private byte rsv1 = 0;
    private byte rsv2 = 0;
    private byte rsv3 = 0;
    private byte opcode = 1;
    private byte mask;
    private byte payloadLen = 1;
    private short payloadLenExtended = 0;
    private long payloadLenExtendedContinued = 0L;
    private byte[] maskingKey = null;
    private int readCount = 0;
    private boolean readFinish = false;
    private byte[] headers = new byte[8];
    private int dataLengthByte = 0;
    private AutoByteBuffer payloadData = AutoByteBuffer.newByteBuffer();

    public boolean isReadFinish() {
        return this.readFinish;
    }

    public void setReadFinish(boolean readFinish) {
        this.readFinish = readFinish;
    }

    public byte getFin() {
        return this.fin;
    }

    public void setFin(byte fin) {
        this.fin = fin;
    }

    public byte getMask() {
        return this.mask;
    }

    public boolean isMask() {
        return 0 == (this.mask ^ 0xFFFFFF80);
    }

    public void setMask(byte mask) {
        this.mask = mask;
    }

    public byte[] getMaskingKey() {
        return this.maskingKey;
    }

    public void setMaskingKey(byte ... maskingKey) {
        this.maskingKey = maskingKey;
    }

    public byte getOpcode() {
        return this.opcode;
    }

    public void setOpcode(byte opcode) {
        this.opcode = opcode;
    }

    public byte[] getPayloadData() {
        return this.payloadData.readableBytesArray();
    }

    public void setPayloadData(byte[] payloadData) {
        this.payloadData.writeBytes(payloadData);
        if (this.getPayloadLenExtended() > 0 && this.payloadData.readableBytes() == this.getPayloadLenExtended()) {
            this.readFinish = true;
        } else if (this.payloadData.readableBytes() == this.getPayloadLen()) {
            this.readFinish = true;
        }
    }

    public byte getPayloadLen() {
        return this.payloadLen;
    }

    public void setPayloadLen(byte payloadLen) {
        this.payloadLen = payloadLen;
    }

    public short getPayloadLenExtended() {
        return this.payloadLenExtended;
    }

    public void setPayloadLenExtended(short payloadLenExtended) {
        this.payloadLenExtended = payloadLenExtended;
    }

    public long getPayloadLenExtendedContinued() {
        return this.payloadLenExtendedContinued;
    }

    public void setPayloadLenExtendedContinued(long payloadLenExtendedContinued) {
        this.payloadLenExtendedContinued = payloadLenExtendedContinued;
    }

    public byte getRsv1() {
        return this.rsv1;
    }

    public void setRsv1(byte rsv1) {
        this.rsv1 = rsv1;
    }

    public byte getRsv2() {
        return this.rsv2;
    }

    public void setRsv2(byte rsv2) {
        this.rsv2 = rsv2;
    }

    public byte getRsv3() {
        return this.rsv3;
    }

    public void setRsv3(byte rsv3) {
        this.rsv3 = rsv3;
    }

    public long getDateLength() {
        if (this.getPayloadLenExtendedContinued() > 0L) {
            return this.getPayloadLenExtendedContinued();
        }
        if (this.getPayloadLenExtended() > 0) {
            return this.getPayloadLenExtended();
        }
        if (this.getPayloadLen() == 126 || this.getPayloadLen() == 127) {
            return 0L;
        }
        return this.getPayloadLen();
    }

    public void setDateLength(long len) {
        if (len < 126L) {
            this.payloadLen = (byte)len;
            this.payloadLenExtended = 0;
            this.payloadLenExtendedContinued = 0L;
        } else if (len < 65534L) {
            this.payloadLen = (byte)126;
            this.payloadLenExtended = (short)len;
            this.payloadLenExtendedContinued = 0L;
        } else {
            this.payloadLen = (byte)127;
            this.payloadLenExtended = 0;
            this.payloadLenExtendedContinued = len;
        }
    }

    public int computeCount(AutoByteBuffer buffer, int count) {
        return buffer.readableBytes() >= count ? count : buffer.readableBytes();
    }

    public void parseMessageHeader(AutoByteBuffer buffer) throws Exception {
        int count;
        switch (this.readCount) {
            case 0: {
                int bt;
                if (buffer.hasRemaining()) {
                    bt = buffer.read();
                    ++this.readCount;
                    this.setFin((byte)(bt & 0xFFFFFF80));
                    this.setRsv1((byte)(bt & 0x70));
                    this.setRsv2((byte)(bt & 0x30));
                    this.setRsv3((byte)(bt & 0x10));
                    this.setOpcode((byte)(bt & 0xF));
                } else {
                    return;
                }
            }
            case 1: {
                int bt;
                if (buffer.hasRemaining()) {
                    bt = buffer.read();
                    ++this.readCount;
                    this.setMask((byte)(bt & 0xFFFFFF80));
                    this.setDateLength(bt & 0x7F);
                } else {
                    return;
                }
            }
            case 2: 
            case 3: {
                int bt;
                if (this.getDateLength() == 126L) {
                    this.dataLengthByte = 2;
                    count = this.computeCount(buffer, 2 - (this.readCount - 2));
                    if (count <= 0) {
                        return;
                    }
                    buffer.readBytes(this.headers, this.readCount - 2, count);
                    this.readCount += count;
                    if (this.readCount - 2 >= 2) {
                        bt = this.headers[0];
                        byte b2 = this.headers[1];
                        this.setDateLength(ObjectUtil.toLong((byte[])new byte[]{(byte)bt, b2}));
                    } else {
                        return;
                    }
                }
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                if (this.getDateLength() != 127L) break;
                this.dataLengthByte = 8;
                count = this.computeCount(buffer, 8 - (this.readCount - 2));
                if (count <= 0) {
                    return;
                }
                buffer.readBytes(this.headers, this.readCount - 2, count);
                this.readCount += count;
                if (this.readCount - 2 >= 8) {
                    this.setDateLength(ObjectUtil.toLong((byte[])this.headers));
                    break;
                }
                return;
            }
        }
        if (this.isMask()) {
            count = this.computeCount(buffer, 4 - (this.readCount - 2 - this.dataLengthByte));
            if (count <= 0) {
                return;
            }
            buffer.readBytes(this.headers, this.readCount - 2 - this.dataLengthByte, count);
            this.readCount += count;
            if (this.readCount - 2 - this.dataLengthByte >= 4) {
                this.setMaskingKey(this.headers[0], this.headers[1], this.headers[2], this.headers[3]);
            } else {
                return;
            }
        }
    }
}

