/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.expansion.handler.timeout;

import com.gettyio.core.channel.AioChannel;
import com.gettyio.core.channel.NioChannel;
import com.gettyio.core.channel.SocketChannel;
import com.gettyio.core.channel.config.BaseConfig;
import com.gettyio.core.channel.internal.ReadCompletionHandler;
import com.gettyio.core.channel.internal.WriteCompletionHandler;
import com.gettyio.core.channel.starter.ConnectHandler;
import com.gettyio.core.handler.ssl.sslfacade.IHandshakeCompletedListener;
import com.gettyio.core.logging.InternalLogger;
import com.gettyio.core.logging.InternalLoggerFactory;
import com.gettyio.core.pipeline.in.ChannelInboundHandlerAdapter;
import com.gettyio.core.util.ThreadPool;
import com.gettyio.core.util.timer.HashedWheelTimer;
import com.gettyio.core.util.timer.Timeout;
import com.gettyio.core.util.timer.TimerTask;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ReConnectHandler
extends ChannelInboundHandlerAdapter
implements TimerTask {
    private final InternalLogger logger = InternalLoggerFactory.getInstance(ReConnectHandler.class);
    private int attempts = 0;
    private long threshold = 1000L;
    private final HashedWheelTimer timer = new HashedWheelTimer();
    private SocketChannel channel;
    private ConnectHandler connectHandler;
    private int connectTimeout = 3000;

    public ReConnectHandler(ConnectHandler connectHandler) {
        this.connectHandler = connectHandler;
    }

    public ReConnectHandler(int threshold, ConnectHandler connectHandler) {
        this.threshold = threshold;
        this.connectHandler = connectHandler;
    }

    public ReConnectHandler(int threshold, int connectTimeout, ConnectHandler connectHandler) {
        this.connectTimeout = connectTimeout;
        this.connectHandler = connectHandler;
    }

    public void channelAdded(SocketChannel socketChannel) throws Exception {
        this.channel = socketChannel;
        this.attempts = 0;
        super.channelAdded(socketChannel);
    }

    public void channelClosed(SocketChannel socketChannel) throws Exception {
        if (!socketChannel.isInitiateClose() && this.timer.workerState == 0) {
            this.reConnect(socketChannel);
        }
        super.channelClosed(socketChannel);
    }

    public void exceptionCaught(SocketChannel socketChannel, Throwable cause) throws Exception {
        if (this.timer.workerState == 0) {
            this.reConnect(socketChannel);
        }
        super.exceptionCaught(socketChannel, cause);
    }

    public void run(Timeout timeout) throws Exception {
        final BaseConfig clientConfig = this.channel.getConfig();
        final ThreadPool workerThreadPool = new ThreadPool(0, 1);
        if (this.channel instanceof AioChannel) {
            AsynchronousSocketChannel socketChannel = AsynchronousSocketChannel.open(AsynchronousChannelGroup.withFixedThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable target) {
                    return new Thread(target);
                }
            }));
            if (clientConfig.getSocketOptions() != null) {
                for (Map.Entry entry : clientConfig.getSocketOptions().entrySet()) {
                    socketChannel.setOption((SocketOption)entry.getKey(), entry.getValue());
                }
            }
            final AsynchronousSocketChannel finalSocketChannel = socketChannel;
            socketChannel.connect(new InetSocketAddress(clientConfig.getHost(), clientConfig.getPort()), socketChannel, new CompletionHandler<Void, AsynchronousSocketChannel>(){

                @Override
                public void completed(Void result, AsynchronousSocketChannel attachment) {
                    ReConnectHandler.this.logger.info("connect aio server success");
                    ReConnectHandler.this.channel = (SocketChannel)new AioChannel(finalSocketChannel, clientConfig, new ReadCompletionHandler(workerThreadPool), new WriteCompletionHandler(), ReConnectHandler.this.channel.getChunkPool(), ReConnectHandler.this.channel.getChannelPipeline());
                    if (null != ReConnectHandler.this.connectHandler) {
                        if (null != ReConnectHandler.this.channel.getSslHandler()) {
                            ReConnectHandler.this.channel.setSslHandshakeCompletedListener(new IHandshakeCompletedListener(){

                                public void onComplete() {
                                    ReConnectHandler.this.logger.info("Ssl Handshake Completed");
                                    ReConnectHandler.this.connectHandler.onCompleted(ReConnectHandler.this.channel);
                                }
                            });
                        } else {
                            ReConnectHandler.this.connectHandler.onCompleted(ReConnectHandler.this.channel);
                        }
                    }
                    ReConnectHandler.this.channel.starRead();
                }

                @Override
                public void failed(Throwable exc, AsynchronousSocketChannel attachment) {
                    ReConnectHandler.this.logger.error("connect aio server  error", exc);
                    ReConnectHandler.this.reConnect(ReConnectHandler.this.channel);
                    if (null != ReConnectHandler.this.connectHandler) {
                        ReConnectHandler.this.connectHandler.onFailed(exc);
                    }
                }
            });
        } else if (this.channel instanceof NioChannel) {
            java.nio.channels.SocketChannel socketChannel = java.nio.channels.SocketChannel.open();
            if (clientConfig.getSocketOptions() != null) {
                for (Map.Entry entry : clientConfig.getSocketOptions().entrySet()) {
                    socketChannel.setOption((SocketOption)entry.getKey(), entry.getValue());
                }
            }
            socketChannel.configureBlocking(false);
            socketChannel.connect(new InetSocketAddress(clientConfig.getHost(), clientConfig.getPort()));
            Selector selector = Selector.open();
            socketChannel.register(selector, 8);
            while (selector.select() > 0) {
                Iterator<SelectionKey> it = selector.selectedKeys().iterator();
                while (it.hasNext()) {
                    java.nio.channels.SocketChannel channels;
                    SelectionKey sk = it.next();
                    if (!sk.isConnectable() || !(channels = (java.nio.channels.SocketChannel)sk.channel()).isConnectionPending()) continue;
                    try {
                        channels.finishConnect();
                        this.channel = new NioChannel(clientConfig, socketChannel, ((NioChannel)this.channel).getNioEventLoop(), this.channel.getChannelPipeline());
                        if (null != this.connectHandler) {
                            if (null != this.channel.getSslHandler()) {
                                this.channel.setSslHandshakeCompletedListener(new IHandshakeCompletedListener(){

                                    public void onComplete() {
                                        ReConnectHandler.this.logger.info("Ssl Handshake Completed");
                                        ReConnectHandler.this.connectHandler.onCompleted(ReConnectHandler.this.channel);
                                    }
                                });
                            } else {
                                this.connectHandler.onCompleted(this.channel);
                            }
                        }
                        ((NioChannel)this.channel).register();
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                        this.reConnect(this.channel);
                        if (null != this.connectHandler) {
                            this.connectHandler.onFailed((Throwable)e);
                        }
                        return;
                    }
                }
                it.remove();
            }
        }
    }

    public void reConnect(SocketChannel socketChannel) {
        if (socketChannel.isInvalid()) {
            this.logger.debug("reconnect...");
            long timeout = (long)this.attempts * this.threshold;
            this.timer.newTimeout((TimerTask)this, timeout, TimeUnit.MILLISECONDS);
            if (this.attempts < 10) {
                ++this.attempts;
            }
        }
    }
}

