/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.click;

import android.view.View;
import com.zzh.lib.views.shine.ShineImageView;

public class OnButtonClickListener
implements View.OnClickListener {
    private final ShineImageView siv;
    protected boolean isCheckFastClick = false;
    protected long interval = 300L;
    private long lastClickTime = 0L;
    View.OnClickListener listener;

    public OnButtonClickListener(ShineImageView siv) {
        this.siv = siv;
    }

    public void setListener(View.OnClickListener listener) {
        this.listener = listener;
    }

    public OnButtonClickListener(ShineImageView siv, View.OnClickListener l) {
        this.siv = siv;
        this.listener = l;
    }

    public void onClick(View view) {
        if (this.isCheckFastClick) {
            if (System.currentTimeMillis() - this.lastClickTime > this.interval) {
                if (!this.siv.isChecked()) {
                    this.siv.setChecked(true);
                    this.siv.showAnim();
                } else {
                    this.siv.setChecked(false);
                    this.siv.setCancel();
                }
                this.siv.onListenerUpdate(this.siv.isChecked());
                if (this.listener != null) {
                    this.listener.onClick(view);
                }
            }
            this.lastClickTime = System.currentTimeMillis();
        } else {
            if (!this.siv.isChecked()) {
                this.siv.setChecked(true);
                this.siv.showAnim();
            } else {
                this.siv.setChecked(false);
                this.siv.setCancel();
            }
            this.siv.onListenerUpdate(this.siv.isChecked());
            if (this.listener != null) {
                this.listener.onClick(view);
            }
        }
    }
}

