/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.ListView;
import androidx.annotation.RequiresApi;
import com.zzh.lib.views.R;
import com.zzh.lib.views.def.IExpandMoreCallback;

public class AutoListView
extends ListView {
    private View footMoreView;
    private boolean isEnableExpandMore;
    private boolean isAddFootMoreView = false;
    private boolean isManualRemove = false;

    public AutoListView(Context context) {
        super(context);
    }

    public AutoListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
    }

    private void initAttrs(Context ctx, AttributeSet attrs) {
        int layoutResId;
        TypedArray mTypedArray = ctx.obtainStyledAttributes(attrs, R.styleable.AutoListView);
        if (mTypedArray.hasValue(R.styleable.AutoListView_zh_foot_more_view) && (layoutResId = mTypedArray.getResourceId(R.styleable.AutoListView_zh_foot_more_view, 0)) != 0) {
            this.footMoreView = LayoutInflater.from((Context)ctx).inflate(layoutResId, (ViewGroup)this, false);
            if (this.footMoreView != null) {
                this.footMoreView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        Log.e((String)"-----", (String)"--------");
                    }
                });
            }
        }
        mTypedArray.recycle();
    }

    public AutoListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs);
    }

    public View getFootMoreView() {
        return this.footMoreView;
    }

    public void setFootMoreView(View footMoreView) {
        this.footMoreView = footMoreView;
    }

    @RequiresApi(api=21)
    public AutoListView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initAttrs(context, attrs);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int expandSpec = View.MeasureSpec.makeMeasureSpec((int)0x1FFFFFFF, (int)Integer.MIN_VALUE);
        super.onMeasure(widthMeasureSpec, expandSpec);
    }

    public void setAdapter(final ListAdapter adapter) {
        super.setAdapter(adapter);
        if (adapter instanceof IExpandMoreCallback && this.footMoreView != null) {
            adapter.registerDataSetObserver(new DataSetObserver(){

                public void onChanged() {
                    super.onChanged();
                    int count = ((IExpandMoreCallback)adapter).getRealCount();
                    int maxItem = ((IExpandMoreCallback)adapter).getMaxItem();
                    boolean bl = AutoListView.this.isEnableExpandMore = maxItem > 0 && count > maxItem && AutoListView.this.footMoreView != null;
                    if (AutoListView.this.isEnableExpandMore && !AutoListView.this.isAddFootMoreView && !AutoListView.this.isManualRemove) {
                        AutoListView.this.isAddFootMoreView = true;
                        AutoListView.this.addFooterView(AutoListView.this.footMoreView);
                    }
                    if (maxItem > count && AutoListView.this.footMoreView != null && AutoListView.this.isAddFootMoreView) {
                        AutoListView.this.isAddFootMoreView = false;
                        AutoListView.this.removeFooterView(AutoListView.this.footMoreView);
                    }
                }

                public void onInvalidated() {
                    super.onInvalidated();
                }
            });
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    public AutoListView resetManualRemove() {
        this.isManualRemove = false;
        return this;
    }

    public void removeExpandMoreView() {
        if (this.footMoreView != null && this.isAddFootMoreView) {
            this.isAddFootMoreView = false;
            this.isManualRemove = true;
            this.removeFooterView(this.footMoreView);
        }
    }
}

