/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.customview.widget.ViewDragHelper;
import com.zzh.lib.views.R;
import com.zzh.lib.views.listener.HDragViewCallback;

public class HDragViewLayout
extends FrameLayout {
    public static final String tag = "HDragViewLayout";
    private boolean debug = false;
    private View mLockBtn;
    private ViewDragHelper mViewDragHelper;
    HDragViewCallback mHDragViewCallback;

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public HDragViewCallback getDragViewCallback() {
        return this.mHDragViewCallback;
    }

    public HDragViewLayout setDragViewCallback(HDragViewCallback HDragViewCallback2) {
        this.mHDragViewCallback = HDragViewCallback2;
        return this;
    }

    public HDragViewLayout(Context context) {
        this(context, null);
    }

    public HDragViewLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HDragViewLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        final HDragViewLayout slideRail = this;
        this.mViewDragHelper = ViewDragHelper.create((ViewGroup)this, (float)0.3f, (ViewDragHelper.Callback)new ViewDragHelper.Callback(){

            public boolean tryCaptureView(View child, int pointerId) {
                return child == HDragViewLayout.this.mLockBtn;
            }

            public int clampViewPositionHorizontal(View child, int left, int dx) {
                int lockBtnWidth = HDragViewLayout.this.mLockBtn.getWidth();
                int fullWidth = slideRail.getWidth();
                int leftMinDistance = HDragViewLayout.this.getPaddingStart();
                int leftMaxDistance = fullWidth - HDragViewLayout.this.getPaddingEnd() - lockBtnWidth;
                if (left < leftMinDistance) {
                    return leftMinDistance;
                }
                if (left > leftMaxDistance) {
                    return leftMaxDistance;
                }
                return left;
            }

            public int clampViewPositionVertical(View child, int top, int dy) {
                int lockBtnHeight = HDragViewLayout.this.mLockBtn.getHeight();
                int fullHeight = slideRail.getHeight();
                int topMinDistance = HDragViewLayout.this.getPaddingTop();
                int topMaxDistance = fullHeight - HDragViewLayout.this.getPaddingBottom() - lockBtnHeight;
                if (top < topMinDistance) {
                    return topMinDistance;
                }
                if (top > topMaxDistance) {
                    return topMaxDistance;
                }
                return top;
            }

            public void onViewCaptured(View capturedChild, int activePointerId) {
                super.onViewCaptured(capturedChild, activePointerId);
                if (HDragViewLayout.this.debug) {
                    Log.d((String)HDragViewLayout.tag, (String)("onViewCaptured, activePointerId: " + activePointerId));
                }
                if (HDragViewLayout.this.mHDragViewCallback != null) {
                    HDragViewLayout.this.mHDragViewCallback.onViewCaptured(capturedChild, activePointerId);
                }
            }

            public void onViewReleased(View releasedChild, float xvel, float yvel) {
                super.onViewReleased(releasedChild, xvel, yvel);
                if (HDragViewLayout.this.debug) {
                    Log.d((String)HDragViewLayout.tag, (String)("onViewReleased, xvel: " + xvel + ", yvel: " + yvel));
                }
                if (HDragViewLayout.this.mHDragViewCallback != null) {
                    HDragViewLayout.this.mHDragViewCallback.onViewReleased(releasedChild, xvel, yvel);
                }
            }

            public void onViewDragStateChanged(int state) {
                super.onViewDragStateChanged(state);
                if (HDragViewLayout.this.debug) {
                    Log.d((String)HDragViewLayout.tag, (String)("onViewDragStateChanged, state: " + state));
                }
            }

            public void onViewPositionChanged(@NonNull View changedView, int left, int top, int dx, int dy) {
                super.onViewPositionChanged(changedView, left, top, dx, dy);
                if (HDragViewLayout.this.debug) {
                    Log.d((String)HDragViewLayout.tag, (String)("onViewPositionChanged: " + left + ", " + top + ", " + dx + ", " + dy));
                }
                if (HDragViewLayout.this.mHDragViewCallback != null) {
                    HDragViewLayout.this.mHDragViewCallback.onViewPositionChanged(changedView, left, top, dx, dy);
                }
            }

            public void onEdgeTouched(int edgeFlags, int pointerId) {
                super.onEdgeTouched(edgeFlags, pointerId);
                if (HDragViewLayout.this.debug) {
                    Log.d((String)HDragViewLayout.tag, (String)("onEdgeTouched: edgeFlags: " + edgeFlags + ", pointerId: " + pointerId));
                }
            }

            public boolean onEdgeLock(int edgeFlags) {
                if (HDragViewLayout.this.debug) {
                    Log.d((String)HDragViewLayout.tag, (String)("onEdgeLock: edgeFlags: " + edgeFlags));
                }
                return super.onEdgeLock(edgeFlags);
            }

            public void onEdgeDragStarted(int edgeFlags, int pointerId) {
                super.onEdgeDragStarted(edgeFlags, pointerId);
                if (HDragViewLayout.this.debug) {
                    Log.d((String)HDragViewLayout.tag, (String)("onEdgeDragStarted: edgeFlags: " + edgeFlags + ", pointerId: " + pointerId));
                }
            }

            public int getOrderedChildIndex(int index) {
                if (HDragViewLayout.this.debug) {
                    Log.d((String)HDragViewLayout.tag, (String)("getOrderedChildIndex: index: " + index));
                }
                return super.getOrderedChildIndex(index);
            }

            public int getViewHorizontalDragRange(@NonNull View child) {
                if (HDragViewLayout.this.debug) {
                    Log.d((String)HDragViewLayout.tag, (String)"getViewHorizontalDragRange:  ");
                }
                return super.getViewHorizontalDragRange(child);
            }

            public int getViewVerticalDragRange(@NonNull View child) {
                if (HDragViewLayout.this.debug) {
                    Log.d((String)HDragViewLayout.tag, (String)"getViewVerticalDragRange:  ");
                }
                return super.getViewVerticalDragRange(child);
            }
        });
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mLockBtn = this.findViewById(R.id.h_drag_view);
        if (this.mLockBtn == null) {
            throw new NullPointerException("\u5fc5\u987b\u8981\u6709\u4e00\u4e2a\u6ed1\u52a8\u6ed1\u5757");
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.mViewDragHelper.shouldInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.mViewDragHelper.processTouchEvent(event);
        return true;
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.mViewDragHelper != null && this.mViewDragHelper.continueSettling(true)) {
            this.invalidate();
        }
    }
}

