/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.zzh.lib.views.R;
import java.util.Random;

public class HLoveHeartView
extends RelativeLayout {
    private Context mContext;
    private float[] num = new float[]{-35.0f, -25.0f, 0.0f, 25.0f, 35.0f};
    private Drawable zhLove;
    private int zhDoubleInterval = 300;
    float eventX = 0.0f;
    float eventY = 0.0f;

    public HLoveHeartView(Context context) {
        super(context);
        this.mContext = context;
        this.initAttrs(null);
    }

    public HLoveHeartView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initAttrs(attrs);
    }

    public HLoveHeartView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.initAttrs(attrs);
    }

    public HLoveHeartView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mContext = context;
        this.initAttrs(attrs);
    }

    private void initAttrs(AttributeSet attrs) {
        TypedArray mTypedArray = this.mContext.obtainStyledAttributes(attrs, R.styleable.HLoveHeartView);
        this.zhLove = mTypedArray.getDrawable(R.styleable.HLoveHeartView_zh_love);
        this.zhDoubleInterval = mTypedArray.getInt(R.styleable.HLoveHeartView_zh_double_interval, 300);
        mTypedArray.recycle();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.zhLove == null || this.zhDoubleInterval <= 0) {
            return super.onTouchEvent(event);
        }
        switch (event.getAction()) {
            case 0: {
                this.eventX = event.getX();
                this.eventY = event.getY();
            }
        }
        return super.onTouchEvent(event);
    }

    public void showHeartAnim() {
        this.showHeartAnim(this.eventX, this.eventY);
    }

    public void showHeartAnim(float x, float y) {
        final ImageView iv = new ImageView(this.mContext);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(300, 300);
        lp.leftMargin = (int)(x - 150.0f);
        lp.topMargin = (int)(y - 300.0f);
        iv.setImageDrawable(this.zhLove);
        iv.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.addView((View)iv);
        AnimatorSet animatorSet = new AnimatorSet();
        int anInt = new Random().nextInt(4);
        animatorSet.play((Animator)this.scaleAni((View)iv, "scaleX", 2.0f, 0.9f, 100L, 0L)).with((Animator)this.scaleAni((View)iv, "scaleY", 2.0f, 0.9f, 100L, 0L)).with((Animator)this.rotation((View)iv, 0L, 0L, this.num[anInt])).with((Animator)this.alphaAni((View)iv, 0.0f, 1.0f, 100L, 0L)).with((Animator)this.scaleAni((View)iv, "scaleX", 0.9f, 1.0f, 50L, 150L)).with((Animator)this.scaleAni((View)iv, "scaleY", 0.9f, 1.0f, 50L, 150L)).with((Animator)this.translationY((View)iv, 0.0f, -600.0f, 800L, 400L)).with((Animator)this.alphaAni((View)iv, 1.0f, 0.0f, 300L, 400L)).with((Animator)this.scaleAni((View)iv, "scaleX", 1.0f, 3.0f, 700L, 400L)).with((Animator)this.scaleAni((View)iv, "scaleY", 1.0f, 3.0f, 700L, 400L));
        animatorSet.start();
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                HLoveHeartView.this.removeViewInLayout((View)iv);
            }
        });
    }

    ObjectAnimator scaleAni(View view, String propertyName, float from, float to, long time, long delayTime) {
        ObjectAnimator ani = ObjectAnimator.ofFloat((Object)view, (String)propertyName, (float[])new float[]{from, to});
        ani.setInterpolator((TimeInterpolator)new LinearInterpolator());
        ani.setStartDelay(delayTime);
        ani.setDuration(time);
        return ani;
    }

    ObjectAnimator translationX(View view, float from, float to, long time, long delayTime) {
        ObjectAnimator ani = ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{from, to});
        ani.setInterpolator((TimeInterpolator)new LinearInterpolator());
        ani.setStartDelay(delayTime);
        ani.setDuration(time);
        return ani;
    }

    ObjectAnimator translationY(View view, float from, float to, long time, long delayTime) {
        ObjectAnimator ani = ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{from, to});
        ani.setInterpolator((TimeInterpolator)new LinearInterpolator());
        ani.setStartDelay(delayTime);
        ani.setDuration(time);
        return ani;
    }

    ObjectAnimator alphaAni(View view, float from, float to, long time, long delayTime) {
        ObjectAnimator ani = ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{from, to});
        ani.setInterpolator((TimeInterpolator)new LinearInterpolator());
        ani.setStartDelay(delayTime);
        ani.setDuration(time);
        return ani;
    }

    ObjectAnimator rotation(View view, Long time, long delayTime, float ... values) {
        ObjectAnimator ani = ObjectAnimator.ofFloat((Object)view, (String)"rotation", (float[])values);
        ani.setDuration(time.longValue());
        ani.setStartDelay(delayTime);
        ani.setInterpolator(input -> input);
        return ani;
    }
}

