/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import androidx.core.view.NestedScrollingChild;
import androidx.core.view.NestedScrollingChildHelper;
import androidx.core.view.NestedScrollingParent;
import androidx.core.view.NestedScrollingParentHelper;
import androidx.core.view.ViewCompat;
import com.zzh.lib.views.def.LoadingView;
import com.zzh.lib.views.def.PullToRefreshView;
import com.zzh.lib.views.gesture.HGestureManager;
import com.zzh.lib.views.gesture.HTouchHelper;
import com.zzh.lib.views.refresh.BasePullToRefreshView;

public class HPullToRefreshView
extends BasePullToRefreshView
implements NestedScrollingParent,
NestedScrollingChild {
    private HGestureManager mGestureManager;
    private final int mTouchSlop;
    private final NestedScrollingParentHelper mNestedScrollingParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
    private final NestedScrollingChildHelper mNestedScrollingChildHelper = new NestedScrollingChildHelper((View)this);
    private final int[] mParentScrollConsumed = new int[2];
    private final int[] mParentOffsetInWindow = new int[2];
    private boolean mIsNestedScrollStarted;
    private boolean mNeedConsumeNestedScroll;

    public HPullToRefreshView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setNestedScrollingEnabled(true);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
    }

    @Override
    public void setDebug(boolean debug) {
        super.setDebug(debug);
        this.getGestureManager().setDebug(debug);
    }

    private HGestureManager getGestureManager() {
        if (this.mGestureManager == null) {
            this.mGestureManager = new HGestureManager(this, new HGestureManager.Callback(){

                @Override
                public boolean shouldInterceptEvent(MotionEvent event) {
                    return HPullToRefreshView.this.canPull();
                }

                @Override
                public boolean shouldConsumeEvent(MotionEvent event) {
                    return HPullToRefreshView.this.mGestureManager.getTagHolder().isTagIntercept() || HPullToRefreshView.this.canPull();
                }

                @Override
                public void onEventConsume(MotionEvent event) {
                    int dy = (int)HPullToRefreshView.this.getGestureManager().getTouchHelper().getDeltaY();
                    HPullToRefreshView.this.moveViews(dy, true);
                }

                @Override
                public void onEventFinish(VelocityTracker velocityTracker, MotionEvent event) {
                    if (HPullToRefreshView.this.mGestureManager.getLifecycleInfo().hasConsumeEvent()) {
                        if (HPullToRefreshView.this.mIsDebug) {
                            Log.e((String)HPullToRefreshView.this.getDebugTag(), (String)("onConsumeEventFinish:" + event.getAction() + " " + (Object)((Object)HPullToRefreshView.this.getState())));
                        }
                        HPullToRefreshView.this.processDragFinish();
                    }
                }

                @Override
                public void onStateChanged(HGestureManager.State oldState, HGestureManager.State newState) {
                    switch (newState) {
                        case Consume: {
                            break;
                        }
                        case Fling: {
                            ViewCompat.postInvalidateOnAnimation((View)HPullToRefreshView.this);
                            break;
                        }
                        case Idle: {
                            HPullToRefreshView.this.dealViewIdle();
                        }
                    }
                }

                @Override
                public void onScrollerCompute(int lastX, int lastY, int currX, int currY) {
                    int dy = currY - lastY;
                    HPullToRefreshView.this.moveViews(dy, false);
                    if (HPullToRefreshView.this.mIsDebug) {
                        LoadingView loadingView = HPullToRefreshView.this.getLoadingViewByDirection();
                        int top = ((View)loadingView).getTop();
                        Log.i((String)HPullToRefreshView.this.getDebugTag(), (String)("onScroll:" + top + " " + (Object)((Object)HPullToRefreshView.this.getState())));
                    }
                }
            });
            this.mGestureManager.getTagHolder().setCallback(new HGestureManager.TagHolder.Callback(){

                @Override
                public void onTagInterceptChanged(boolean tag) {
                    HTouchHelper.requestDisallowInterceptTouchEvent((View)HPullToRefreshView.this, tag);
                }

                @Override
                public void onTagConsumeChanged(boolean tag) {
                    HTouchHelper.requestDisallowInterceptTouchEvent((View)HPullToRefreshView.this, tag);
                }
            });
        }
        return this.mGestureManager;
    }

    private void processDragFinish() {
        if (this.getState() == PullToRefreshView.State.RELEASE_TO_REFRESH) {
            this.setState(PullToRefreshView.State.REFRESHING);
        }
        this.updateViewByState();
    }

    private void setDirectionByDelta(int delta) {
        if (delta == 0) {
            throw new IllegalArgumentException();
        }
        if (delta > 0) {
            this.setDirection(PullToRefreshView.Direction.FROM_HEADER);
            this.getGestureManager().getScroller().setMaxScrollDistance(((View)this.getHeaderView()).getHeight());
        } else if (delta < 0) {
            this.setDirection(PullToRefreshView.Direction.FROM_FOOTER);
            this.getGestureManager().getScroller().setMaxScrollDistance(((View)this.getFooterView()).getHeight());
        }
    }

    private boolean canPull() {
        boolean checkNotNestedScroll;
        boolean checkState;
        boolean checkPull;
        boolean checkPullDelta;
        boolean checkDegree;
        boolean bl = checkDegree = this.getGestureManager().getTouchHelper().getDegreeYFromDown() < 30.0;
        if (!checkDegree) {
            return false;
        }
        int deltaY = (int)this.getGestureManager().getTouchHelper().getDeltaYFromDown();
        boolean bl2 = checkPullDelta = Math.abs(deltaY) > this.mTouchSlop;
        if (!checkPullDelta) {
            return false;
        }
        boolean bl3 = checkPull = this.canPullFromHeader() && deltaY > 0 || this.canPullFromFooter() && deltaY < 0;
        if (!checkPull) {
            return false;
        }
        boolean bl4 = checkState = this.getState() == PullToRefreshView.State.RESET;
        if (!checkState) {
            return false;
        }
        boolean bl5 = checkNotNestedScroll = !this.mIsNestedScrollStarted;
        if (!checkNotNestedScroll) {
            return false;
        }
        this.setDirectionByDelta(deltaY);
        return true;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.getGestureManager().onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.getGestureManager().onTouchEvent(event);
    }

    public void computeScroll() {
        if (this.getGestureManager().getScroller().computeScrollOffset()) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    @Override
    protected boolean isViewIdle() {
        boolean checkStateIdle;
        boolean bl = checkStateIdle = this.getGestureManager().getState() == HGestureManager.State.Idle;
        if (!checkStateIdle) {
            return false;
        }
        boolean checkNotNestedScroll = !this.mIsNestedScrollStarted;
        return checkNotNestedScroll;
    }

    @Override
    protected boolean smoothScroll(int startY, int endY) {
        return this.getGestureManager().getScroller().scrollToY(startY, endY, -1);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.getGestureManager().getScroller().abortAnimation();
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        boolean checkTarget;
        boolean checkDirection;
        boolean checkIsScrollToBound;
        boolean checkMode;
        boolean checkState;
        boolean bl = checkState = this.getState() == PullToRefreshView.State.RESET;
        if (!checkState) {
            return false;
        }
        boolean bl2 = checkMode = this.getMode() != PullToRefreshView.Mode.PULL_DISABLE;
        if (!checkMode) {
            return false;
        }
        boolean bl3 = checkIsScrollToBound = HTouchHelper.isScrollToTop(this.getRefreshView()) || HTouchHelper.isScrollToBottom(this.getRefreshView());
        if (!checkIsScrollToBound) {
            return false;
        }
        boolean bl4 = checkDirection = this.getDirection() == PullToRefreshView.Direction.NONE;
        if (!checkDirection) {
            return false;
        }
        boolean bl5 = checkTarget = target == this.getRefreshView();
        if (!checkTarget) {
            return false;
        }
        boolean checkNestedScrollVertical = (nestedScrollAxes & 2) != 0;
        return checkNestedScrollVertical;
    }

    public void onNestedScrollAccepted(View child, View target, int axes) {
        if (this.mIsDebug) {
            Log.i((String)this.getDebugTag(), (String)"onNestedScrollAccepted----------");
        }
        this.mNestedScrollingParentHelper.onNestedScrollAccepted(child, target, axes);
        this.startNestedScroll(axes & 2);
        this.mIsNestedScrollStarted = true;
    }

    public void onStopNestedScroll(View child) {
        if (this.mIsDebug) {
            Log.e((String)this.getDebugTag(), (String)("onStopNestedScroll:" + (Object)((Object)this.getDirection())));
        }
        this.mNestedScrollingParentHelper.onStopNestedScroll(child);
        this.mIsNestedScrollStarted = false;
        if (this.mNeedConsumeNestedScroll) {
            this.mNeedConsumeNestedScroll = false;
            this.processDragFinish();
        }
        this.stopNestedScroll();
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        if (this.mNeedConsumeNestedScroll) {
            consumed[1] = dy;
            this.moveViews(-dy, true);
        }
        if (this.dispatchNestedPreScroll(dx - consumed[0], dy - consumed[1], this.mParentScrollConsumed, null)) {
            consumed[0] = consumed[0] + this.mParentScrollConsumed[0];
            consumed[1] = consumed[1] + this.mParentScrollConsumed[1];
        }
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, this.mParentOffsetInWindow);
        int dy = dyUnconsumed + this.mParentOffsetInWindow[1];
        if (dy == 0) {
            return;
        }
        if (this.getDirection() == PullToRefreshView.Direction.NONE) {
            if (dy < 0) {
                if (this.canPullFromHeader()) {
                    this.setDirection(PullToRefreshView.Direction.FROM_HEADER);
                    this.getGestureManager().getScroller().setMaxScrollDistance(((View)this.getHeaderView()).getHeight());
                }
            } else if (dy > 0 && this.canPullFromFooter()) {
                this.setDirection(PullToRefreshView.Direction.FROM_FOOTER);
                this.getGestureManager().getScroller().setMaxScrollDistance(((View)this.getFooterView()).getHeight());
            }
            if (this.getDirection() != PullToRefreshView.Direction.NONE) {
                this.mNeedConsumeNestedScroll = true;
                if (this.mIsDebug) {
                    Log.i((String)this.getDebugTag(), (String)"onNestedScroll need consume");
                }
            }
        }
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return this.dispatchNestedPreFling(velocityX, velocityY);
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return this.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public int getNestedScrollAxes() {
        return this.mNestedScrollingParentHelper.getNestedScrollAxes();
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mNestedScrollingChildHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mNestedScrollingChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.mNestedScrollingChildHelper.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        this.mNestedScrollingChildHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.mNestedScrollingChildHelper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.mNestedScrollingChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreFling(velocityX, velocityY);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.mNestedScrollingChildHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }
}

