/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.OvershootInterpolator;
import com.zzh.lib.views.R;

public class HSwipeMenuView
extends ViewGroup {
    private int mScaleTouchSlop;
    private int mMaxVelocity;
    private int mPointerId;
    private int mHeight;
    private int mRightMenuWidths;
    private int mLimit;
    private View mContentView;
    private final PointF mLastP = new PointF();
    private boolean isUnMoved = true;
    private final PointF mFirstP = new PointF();
    private boolean isUserSwiped;
    private static HSwipeMenuView mViewCache;
    private static boolean isTouching;
    private VelocityTracker mVelocityTracker;
    private Log LogUtils;
    private boolean isSwipeEnable;
    private boolean isIos;
    private boolean iosInterceptFlag;
    private boolean isLeftSwipe;
    private ValueAnimator mExpandAnim;
    private ValueAnimator mCloseAnim;
    private boolean isExpand;

    public HSwipeMenuView(Context context) {
        this(context, null);
    }

    public HSwipeMenuView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HSwipeMenuView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    public boolean isSwipeEnable() {
        return this.isSwipeEnable;
    }

    public void setSwipeEnable(boolean swipeEnable) {
        this.isSwipeEnable = swipeEnable;
    }

    public boolean isIos() {
        return this.isIos;
    }

    public HSwipeMenuView setIos(boolean ios) {
        this.isIos = ios;
        return this;
    }

    public boolean isLeftSwipe() {
        return this.isLeftSwipe;
    }

    public HSwipeMenuView setLeftSwipe(boolean leftSwipe) {
        this.isLeftSwipe = leftSwipe;
        return this;
    }

    public static HSwipeMenuView getViewCache() {
        return mViewCache;
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mScaleTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mMaxVelocity = ViewConfiguration.get((Context)context).getScaledMaximumFlingVelocity();
        this.isSwipeEnable = true;
        this.isIos = true;
        this.isLeftSwipe = true;
        TypedArray ta = context.getTheme().obtainStyledAttributes(attrs, R.styleable.HSwipeMenuView, defStyleAttr, 0);
        int count = ta.getIndexCount();
        for (int i = 0; i < count; ++i) {
            int attr = ta.getIndex(i);
            if (attr == R.styleable.HSwipeMenuView_zh_swipe_enable) {
                this.isSwipeEnable = ta.getBoolean(attr, true);
                continue;
            }
            if (attr == R.styleable.HSwipeMenuView_zh_ios) {
                this.isIos = ta.getBoolean(attr, true);
                continue;
            }
            if (attr != R.styleable.HSwipeMenuView_zh_left_swipe) continue;
            this.isLeftSwipe = ta.getBoolean(attr, true);
        }
        ta.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setClickable(true);
        this.mRightMenuWidths = 0;
        this.mHeight = 0;
        int contentWidth = 0;
        int childCount = this.getChildCount();
        boolean measureMatchParentChildren = View.MeasureSpec.getMode((int)heightMeasureSpec) != 0x40000000;
        boolean isNeedMeasureChildHeight = false;
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(i);
            childView.setClickable(true);
            if (childView.getVisibility() == 8) continue;
            this.measureChild(childView, widthMeasureSpec, heightMeasureSpec);
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)childView.getLayoutParams();
            this.mHeight = Math.max(this.mHeight, childView.getMeasuredHeight());
            if (measureMatchParentChildren && lp.height == -1) {
                isNeedMeasureChildHeight = true;
            }
            if (i > 0) {
                this.mRightMenuWidths += childView.getMeasuredWidth();
                continue;
            }
            this.mContentView = childView;
            contentWidth = childView.getMeasuredWidth();
        }
        this.setMeasuredDimension(this.getPaddingLeft() + this.getPaddingRight() + contentWidth, this.mHeight + this.getPaddingTop() + this.getPaddingBottom());
        this.mLimit = this.mRightMenuWidths * 4 / 10;
        if (isNeedMeasureChildHeight) {
            this.forceUniformHeight(childCount, widthMeasureSpec);
        }
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    private void forceUniformHeight(int count, int widthMeasureSpec) {
        int uniformMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredHeight(), (int)0x40000000);
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            if (lp.height != -1) continue;
            int oldWidth = lp.width;
            lp.width = child.getMeasuredWidth();
            this.measureChildWithMargins(child, widthMeasureSpec, 0, uniformMeasureSpec, 0);
            lp.width = oldWidth;
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int childCount = this.getChildCount();
        int left = 0 + this.getPaddingLeft();
        int right = 0 + this.getPaddingLeft();
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(i);
            if (childView.getVisibility() == 8) continue;
            if (i == 0) {
                childView.layout(left, this.getPaddingTop(), left + childView.getMeasuredWidth(), this.getPaddingTop() + childView.getMeasuredHeight());
                left += childView.getMeasuredWidth();
                continue;
            }
            if (this.isLeftSwipe) {
                childView.layout(left, this.getPaddingTop(), left + childView.getMeasuredWidth(), this.getPaddingTop() + childView.getMeasuredHeight());
                left += childView.getMeasuredWidth();
                continue;
            }
            childView.layout(right - childView.getMeasuredWidth(), this.getPaddingTop(), right, this.getPaddingTop() + childView.getMeasuredHeight());
            right -= childView.getMeasuredWidth();
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.isSwipeEnable) {
            this.acquireVelocityTracker(ev);
            VelocityTracker verTracker = this.mVelocityTracker;
            switch (ev.getAction()) {
                case 0: {
                    this.isUserSwiped = false;
                    this.isUnMoved = true;
                    this.iosInterceptFlag = false;
                    if (isTouching) {
                        return false;
                    }
                    isTouching = true;
                    this.mLastP.set(ev.getRawX(), ev.getRawY());
                    this.mFirstP.set(ev.getRawX(), ev.getRawY());
                    if (mViewCache != null) {
                        if (mViewCache != this) {
                            mViewCache.smoothClose();
                            this.iosInterceptFlag = this.isIos;
                        }
                        this.getParent().requestDisallowInterceptTouchEvent(true);
                    }
                    this.mPointerId = ev.getPointerId(0);
                    break;
                }
                case 2: {
                    if (this.iosInterceptFlag) break;
                    float gap = this.mLastP.x - ev.getRawX();
                    if (Math.abs(gap) > 10.0f || Math.abs(this.getScrollX()) > 10) {
                        this.getParent().requestDisallowInterceptTouchEvent(true);
                    }
                    if (Math.abs(gap) > (float)this.mScaleTouchSlop) {
                        this.isUnMoved = false;
                    }
                    this.scrollBy((int)gap, 0);
                    if (this.isLeftSwipe) {
                        if (this.getScrollX() < 0) {
                            this.scrollTo(0, 0);
                        }
                        if (this.getScrollX() > this.mRightMenuWidths) {
                            this.scrollTo(this.mRightMenuWidths, 0);
                        }
                    } else {
                        if (this.getScrollX() < -this.mRightMenuWidths) {
                            this.scrollTo(-this.mRightMenuWidths, 0);
                        }
                        if (this.getScrollX() > 0) {
                            this.scrollTo(0, 0);
                        }
                    }
                    this.mLastP.set(ev.getRawX(), ev.getRawY());
                    break;
                }
                case 1: 
                case 3: {
                    if (Math.abs(ev.getRawX() - this.mFirstP.x) > (float)this.mScaleTouchSlop) {
                        this.isUserSwiped = true;
                    }
                    if (!this.iosInterceptFlag) {
                        verTracker.computeCurrentVelocity(1000, (float)this.mMaxVelocity);
                        float velocityX = verTracker.getXVelocity(this.mPointerId);
                        if (Math.abs(velocityX) > 1000.0f) {
                            if (velocityX < -1000.0f) {
                                if (this.isLeftSwipe) {
                                    this.smoothExpand();
                                } else {
                                    this.smoothClose();
                                }
                            } else if (this.isLeftSwipe) {
                                this.smoothClose();
                            } else {
                                this.smoothExpand();
                            }
                        } else if (Math.abs(this.getScrollX()) > this.mLimit) {
                            this.smoothExpand();
                        } else {
                            this.smoothClose();
                        }
                    }
                    this.releaseVelocityTracker();
                    isTouching = false;
                    break;
                }
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.isSwipeEnable) {
            switch (ev.getAction()) {
                case 2: {
                    if (!(Math.abs(ev.getRawX() - this.mFirstP.x) > (float)this.mScaleTouchSlop)) break;
                    return true;
                }
                case 1: {
                    if (this.isLeftSwipe) {
                        if (this.getScrollX() > this.mScaleTouchSlop && ev.getX() < (float)(this.getWidth() - this.getScrollX())) {
                            if (this.isUnMoved) {
                                this.smoothClose();
                            }
                            return true;
                        }
                    } else if (-this.getScrollX() > this.mScaleTouchSlop && ev.getX() > (float)(-this.getScrollX())) {
                        if (this.isUnMoved) {
                            this.smoothClose();
                        }
                        return true;
                    }
                    if (!this.isUserSwiped) break;
                    return true;
                }
            }
            if (this.iosInterceptFlag) {
                return true;
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    public void smoothExpand() {
        mViewCache = this;
        if (null != this.mContentView) {
            this.mContentView.setLongClickable(false);
        }
        this.cancelAnim();
        this.mExpandAnim = ValueAnimator.ofInt((int[])new int[]{this.getScrollX(), this.isLeftSwipe ? this.mRightMenuWidths : -this.mRightMenuWidths});
        this.mExpandAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                HSwipeMenuView.this.scrollTo((Integer)animation.getAnimatedValue(), 0);
            }
        });
        this.mExpandAnim.setInterpolator((TimeInterpolator)new OvershootInterpolator());
        this.mExpandAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                HSwipeMenuView.this.isExpand = true;
            }
        });
        this.mExpandAnim.setDuration(300L).start();
    }

    private void cancelAnim() {
        if (this.mCloseAnim != null && this.mCloseAnim.isRunning()) {
            this.mCloseAnim.cancel();
        }
        if (this.mExpandAnim != null && this.mExpandAnim.isRunning()) {
            this.mExpandAnim.cancel();
        }
    }

    public void smoothClose() {
        mViewCache = null;
        if (null != this.mContentView) {
            this.mContentView.setLongClickable(true);
        }
        this.cancelAnim();
        this.mCloseAnim = ValueAnimator.ofInt((int[])new int[]{this.getScrollX(), 0});
        this.mCloseAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                HSwipeMenuView.this.scrollTo((Integer)animation.getAnimatedValue(), 0);
            }
        });
        this.mCloseAnim.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        this.mCloseAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                HSwipeMenuView.this.isExpand = false;
            }
        });
        this.mCloseAnim.setDuration(300L).start();
    }

    private void acquireVelocityTracker(MotionEvent event) {
        if (null == this.mVelocityTracker) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
    }

    private void releaseVelocityTracker() {
        if (null != this.mVelocityTracker) {
            this.mVelocityTracker.clear();
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    protected void onDetachedFromWindow() {
        if (this == mViewCache) {
            mViewCache.smoothClose();
            mViewCache = null;
        }
        super.onDetachedFromWindow();
    }

    public boolean performLongClick() {
        if (Math.abs(this.getScrollX()) > this.mScaleTouchSlop) {
            return false;
        }
        return super.performLongClick();
    }

    public void quickClose() {
        if (this == mViewCache) {
            this.cancelAnim();
            mViewCache.scrollTo(0, 0);
            mViewCache = null;
        }
    }
}

