/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Region;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ProgressBar;
import com.zzh.lib.views.R;
import com.zzh.lib.views.utils.DimenUtil;

public class HorizontalDownloadProgressBar
extends ProgressBar {
    public static final int DOWNLOADING = 1;
    public static final int PAUSE = 2;
    public static final int FINISH = 3;
    public static final int START = 4;
    private int mState = 4;
    private int mProgressTextColor = Color.parseColor((String)"#4599E9");
    private int mProgressBarColor = Color.parseColor((String)"#D4E9FA");
    private int mProgressTextSize = 18;
    private int mProgressMinHeight = 20;
    private Paint mPaint;
    private int mProgressMinWidth = 30;
    private Path mPath;
    private String downloading = "\u4e0b\u8f7d\u4e2d";
    private String pause = "\u6682\u505c";
    private String finish = "\u4e0b\u8f7d\u5b8c\u6210";
    private String error = "\u4e0b\u8f7d\u5931\u8d25";

    public void setProgressState(int state) {
        this.mState = state;
        this.postInvalidate();
    }

    public int getProgressState() {
        return this.mState;
    }

    public HorizontalDownloadProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
        this.obtainStyledAttributes(context, attrs);
        this.initProgressBar();
    }

    private void obtainStyledAttributes(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.HorizontalDownloadProgressBar);
        this.mProgressTextColor = ta.getColor(R.styleable.HorizontalDownloadProgressBar_zh_progress_text_color, this.mProgressTextColor);
        this.mProgressTextSize = (int)ta.getDimension(R.styleable.HorizontalDownloadProgressBar_zh_progress_text_size, (float)this.mProgressTextSize);
        this.mProgressBarColor = ta.getColor(R.styleable.HorizontalDownloadProgressBar_zh_progress_bar_color, this.mProgressBarColor);
        this.mProgressMinHeight = (int)ta.getDimension(R.styleable.HorizontalDownloadProgressBar_zh_progress_min_height, (float)this.mProgressMinHeight);
        this.mProgressMinWidth = (int)ta.getDimension(R.styleable.HorizontalDownloadProgressBar_zh_progress_min_width, (float)this.mProgressMinWidth);
        if (ta.hasValue(R.styleable.HorizontalDownloadProgressBar_zh_progress_downloading)) {
            this.downloading = ta.getString(R.styleable.HorizontalDownloadProgressBar_zh_progress_downloading);
        }
        if (ta.hasValue(R.styleable.HorizontalDownloadProgressBar_zh_progress_pause)) {
            this.pause = ta.getString(R.styleable.HorizontalDownloadProgressBar_zh_progress_pause);
        }
        if (ta.hasValue(R.styleable.HorizontalDownloadProgressBar_zh_progress_error)) {
            this.error = ta.getString(R.styleable.HorizontalDownloadProgressBar_zh_progress_error);
        }
        if (ta.hasValue(R.styleable.HorizontalDownloadProgressBar_zh_progress_finish)) {
            this.finish = ta.getString(R.styleable.HorizontalDownloadProgressBar_zh_progress_finish);
        }
        ta.recycle();
    }

    private void initProgressBar() {
        this.mPaint = new Paint(1);
        this.mPath = new Path();
        this.mPaint.setTextSize((float)DimenUtil.sp2px(this.getContext(), this.mProgressTextSize));
        this.mPaint.setStrokeWidth((float)DimenUtil.dp2px(this.getContext(), 1.0f));
        this.setClickable(true);
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), heightMeasureSpec);
    }

    protected synchronized void onDraw(Canvas canvas) {
        switch (this.mState) {
            case 1: {
                this.drawProgressOnDownload(canvas);
                break;
            }
            case 2: {
                this.drawProgressOnPause(canvas);
                break;
            }
            case 3: {
                this.drawProgressOnFinished(canvas);
                break;
            }
            case 4: {
                this.drawProgressOnStart(canvas);
                break;
            }
        }
    }

    private void drawProgressOnDownload(Canvas canvas) {
        this.drawProgressRectBackground(canvas);
        this.drawProgressRect(canvas);
        String progressValue = TextUtils.concat((CharSequence[])new CharSequence[]{String.valueOf(this.getProgress()), "%"}).toString();
        this.drawProgressText(canvas, progressValue);
        if (this.getProgress() == this.getMax()) {
            this.postInvalidateDelayed(1000L);
            this.mState = 3;
        }
    }

    private void drawProgressOnPause(Canvas canvas) {
        this.drawProgressRectBackground(canvas);
        this.drawProgressRect(canvas);
        this.drawProgressText(canvas, this.pause);
    }

    private void drawProgressOnFinished(Canvas canvas) {
        this.drawProgressRectBackground(canvas);
        this.drawProgressText(canvas, this.finish);
        this.setEnabled(false);
    }

    private void drawProgressOnStart(Canvas canvas) {
        this.drawProgressRectBackground(canvas);
        this.drawProgressText(canvas, this.downloading);
    }

    private void drawProgressRect(Canvas canvas) {
        int width = this.getWidth() - this.getPaddingRight() - this.getPaddingLeft();
        int height = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(this.mProgressBarColor);
        float radio = (float)this.getProgress() * 1.0f / (float)this.getMax();
        int progress = (int)((float)width * radio);
        canvas.save();
        canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
        this.mPath.reset();
        this.mPath.moveTo((float)height / 2.0f, (float)height);
        this.mPath.arcTo(new RectF(0.0f, 0.0f, (float)height * 1.0f, (float)height * 1.0f), 90.0f, 180.0f);
        this.mPath.lineTo((float)width - (float)height / 2.0f, 0.0f);
        this.mPath.arcTo(new RectF((float)(width - height), 0.0f, (float)width, (float)height), -90.0f, 180.0f);
        this.mPath.lineTo((float)width - (float)height / 2.0f, (float)height);
        this.mPath.lineTo((float)height / 2.0f, (float)height);
        this.mPath.close();
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(this.mProgressBarColor);
        canvas.clipPath(this.mPath);
        this.mPath.reset();
        this.mPath.addRect(new RectF(0.0f, 0.0f, (float)progress, (float)height), Path.Direction.CCW);
        canvas.clipPath(this.mPath, Region.Op.INTERSECT);
        canvas.drawColor(this.mProgressBarColor);
        canvas.restore();
    }

    private void drawProgressRectBackground(Canvas canvas) {
        int width = this.getWidth() - this.getPaddingRight() - this.getPaddingLeft();
        int height = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(this.mProgressBarColor);
        canvas.save();
        canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
        this.mPath.reset();
        float pw = this.mPaint.getStrokeWidth();
        this.mPath.moveTo((float)height / 2.0f - pw / 2.0f, (float)height - pw / 2.0f);
        this.mPath.arcTo(new RectF(pw / 2.0f, pw / 2.0f, (float)height * 1.0f - pw / 2.0f, (float)height * 1.0f - pw / 2.0f), 90.0f, 180.0f);
        this.mPath.lineTo((float)width - (float)height / 2.0f - pw / 2.0f, pw / 2.0f);
        this.mPath.arcTo(new RectF((float)(width - height) + pw / 2.0f, pw / 2.0f, (float)width - pw / 2.0f, (float)height - pw / 2.0f), -90.0f, 180.0f);
        this.mPath.lineTo((float)width - (float)height / 2.0f - pw / 2.0f, (float)height - pw / 2.0f);
        this.mPath.lineTo((float)height / 2.0f - pw / 2.0f, (float)height - pw / 2.0f);
        this.mPath.close();
        canvas.drawPath(this.mPath, this.mPaint);
        canvas.restore();
    }

    private void drawProgressText(Canvas canvas, String text) {
        int width = this.getWidth() - this.getPaddingRight() - this.getPaddingLeft();
        int height = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.save();
        canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
        this.mPaint.setColor(this.mProgressTextColor);
        int textWidth = (int)this.mPaint.measureText(text);
        int textHeight = (int)(this.mPaint.descent() + this.mPaint.ascent());
        canvas.drawText(text, (float)width / 2.0f - (float)textWidth / 2.0f, (float)height / 2.0f - (float)textHeight / 2.0f, this.mPaint);
        canvas.restore();
    }
}

