/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.zzh.lib.views.HBannerViewPager;
import com.zzh.lib.views.adapter.holder.HSuperViewHolder;
import com.zzh.lib.views.utils.BannerUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseBannerAdapter<T>
extends RecyclerView.Adapter<HSuperViewHolder> {
    protected List<T> mList = new ArrayList<T>();
    private boolean isCanLoop;
    public static final int MAX_VALUE = 1000;
    private HBannerViewPager.OnPageClickListener mPageClickListener;

    @NonNull
    public final HSuperViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(this.getLayoutId(viewType), parent, false);
        HSuperViewHolder viewHolder = this.createViewHolder(parent, itemView, viewType);
        itemView.setOnClickListener(clickedView -> {
            int adapterPosition = viewHolder.getAdapterPosition();
            if (this.mPageClickListener != null && adapterPosition != -1) {
                int realPosition = BannerUtils.getRealPosition(viewHolder.getAdapterPosition(), this.getListSize());
                this.mPageClickListener.onPageClick(clickedView, realPosition);
            }
        });
        return viewHolder;
    }

    public final void onBindViewHolder(@NonNull HSuperViewHolder holder, int position) {
        int realPosition = BannerUtils.getRealPosition(position, this.getListSize());
        this.bindData(holder, this.mList.get(realPosition), realPosition, this.getListSize());
    }

    public final int getItemViewType(int position) {
        int realPosition = BannerUtils.getRealPosition(position, this.getListSize());
        return this.getViewType(realPosition);
    }

    public final int getItemCount() {
        if (this.isCanLoop && this.getListSize() > 1) {
            return 1000;
        }
        return this.getListSize();
    }

    public List<T> getData() {
        return this.mList;
    }

    public void setData(List<? extends T> list) {
        if (null != list) {
            this.mList.clear();
            this.mList.addAll(list);
        }
    }

    public void setCanLoop(boolean canLoop) {
        this.isCanLoop = canLoop;
    }

    public void setPageClickListener(HBannerViewPager.OnPageClickListener pageClickListener) {
        this.mPageClickListener = pageClickListener;
    }

    public int getListSize() {
        return this.mList.size();
    }

    public int getViewType(int position) {
        return 0;
    }

    public boolean isCanLoop() {
        return this.isCanLoop;
    }

    public HSuperViewHolder createViewHolder(@NonNull ViewGroup parent, View itemView, int viewType) {
        return new HSuperViewHolder(itemView);
    }

    protected abstract void bindData(HSuperViewHolder var1, T var2, int var3, int var4);

    @LayoutRes
    public abstract int getLayoutId(int var1);
}

