/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import com.zzh.lib.views.adapter.holder.HSuperViewHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class HListBaseAdapter<T>
extends RecyclerView.Adapter<HSuperViewHolder> {
    protected Context mContext;
    protected LayoutInflater mInflater;
    protected List<T> mDataList = new ArrayList<T>();

    public HListBaseAdapter(Context context) {
        this.mContext = context;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
    }

    public HSuperViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = this.mInflater.inflate(this.getLayoutId(), parent, false);
        return new HSuperViewHolder(itemView);
    }

    public void onBindViewHolder(HSuperViewHolder holder, int position) {
        this.onBindItemHolder(holder, position);
    }

    public T getItem(int position) {
        return this.getDataList().get(position);
    }

    public void onBindViewHolder(HSuperViewHolder holder, int position, List<Object> payloads) {
        if (payloads.isEmpty()) {
            this.onBindViewHolder(holder, position);
        } else {
            this.onBindItemHolder(holder, position, payloads);
        }
    }

    public abstract int getLayoutId();

    public abstract void onBindItemHolder(HSuperViewHolder var1, int var2);

    public void onBindItemHolder(HSuperViewHolder holder, int position, List<Object> payloads) {
    }

    public int getItemCount() {
        return this.mDataList.size();
    }

    public List<T> getDataList() {
        return this.mDataList;
    }

    public void setDataList(List<T> list) {
        this.setNewInstance(list);
    }

    public void setNewInstance(List<T> data) {
        if (data != null) {
            this.mDataList = data;
        } else {
            this.mDataList.clear();
        }
        this.notifyDataSetChanged();
    }

    public void addAll(Collection<T> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        int lastIndex = this.mDataList.size();
        if (this.mDataList.addAll(list)) {
            this.notifyItemRangeInserted(lastIndex, list.size());
        }
    }

    public void remove(int position) {
        this.mDataList.remove(position);
        this.notifyItemRemoved(position);
        if (position != this.getDataList().size()) {
            this.notifyItemRangeChanged(position, this.mDataList.size() - position);
        }
    }

    public void clear() {
        this.mDataList.clear();
        this.notifyDataSetChanged();
    }
}

