/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.card;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import com.zzh.lib.views.R;
import com.zzh.lib.views.card.CardViewApi21Impl;
import com.zzh.lib.views.card.CardViewDelegate;
import com.zzh.lib.views.card.CardViewImpl;

public class HCardView
extends FrameLayout {
    private static final CardViewImpl IMPL;
    private static final int[] COLOR_BACKGROUND_ATTR;
    private boolean mCompatPadding;
    private boolean mPreventCornerOverlap;
    int mUserSetMinWidth;
    int mUserSetMinHeight;
    final Rect mContentPadding = new Rect();
    final Rect mShadowBounds = new Rect();
    private final CardViewDelegate mCardViewDelegate = new CardViewDelegate(){
        private Drawable mCardBackground;

        @Override
        public void setCardBackground(Drawable drawable) {
            this.mCardBackground = drawable;
            HCardView.this.setBackgroundDrawable(drawable);
        }

        @Override
        public boolean getUseCompatPadding() {
            return HCardView.this.getUseCompatPadding();
        }

        @Override
        public boolean getPreventCornerOverlap() {
            return HCardView.this.getPreventCornerOverlap();
        }

        @Override
        public void setShadowPadding(int left, int top, int right, int bottom) {
            HCardView.this.mShadowBounds.set(left, top, right, bottom);
            HCardView.super.setPadding(left + HCardView.this.mContentPadding.left, top + HCardView.this.mContentPadding.top, right + HCardView.this.mContentPadding.right, bottom + HCardView.this.mContentPadding.bottom);
        }

        @Override
        public void setMinWidthHeightInternal(int width, int height) {
            if (width > HCardView.this.mUserSetMinWidth) {
                HCardView.super.setMinimumWidth(width);
            }
            if (height > HCardView.this.mUserSetMinHeight) {
                HCardView.super.setMinimumHeight(height);
            }
        }

        @Override
        public Drawable getCardBackground() {
            return this.mCardBackground;
        }

        @Override
        public View getCardView() {
            return HCardView.this;
        }
    };

    public HCardView(@NonNull Context context) {
        this(context, null);
    }

    public HCardView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.hCardViewStyle);
    }

    public HCardView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        ColorStateList backgroundColor;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.HCardView, defStyleAttr, R.style.HCardView);
        ColorStateList cardShadowStartColor = a.getColorStateList(R.styleable.HCardView_cardShadowStartColor);
        ColorStateList cardShadowEndColor = a.getColorStateList(R.styleable.HCardView_cardShadowEndColor);
        if (a.hasValue(R.styleable.HCardView_cardBackgroundColor)) {
            backgroundColor = a.getColorStateList(R.styleable.HCardView_cardBackgroundColor);
        } else {
            TypedArray aa = this.getContext().obtainStyledAttributes(COLOR_BACKGROUND_ATTR);
            int themeColorBackground = aa.getColor(0, 0);
            aa.recycle();
            float[] hsv = new float[3];
            Color.colorToHSV((int)themeColorBackground, (float[])hsv);
            backgroundColor = ColorStateList.valueOf((int)(hsv[2] > 0.5f ? this.getResources().getColor(R.color.h_cardview_light_background) : this.getResources().getColor(R.color.h_cardview_dark_background)));
        }
        float radius = a.getDimension(R.styleable.HCardView_cardCornerRadius, 0.0f);
        float elevation = a.getDimension(R.styleable.HCardView_cardElevation, 0.0f);
        float maxElevation = a.getDimension(R.styleable.HCardView_cardMaxElevation, 0.0f);
        this.mCompatPadding = a.getBoolean(R.styleable.HCardView_cardUseCompatPadding, false);
        this.mPreventCornerOverlap = a.getBoolean(R.styleable.HCardView_cardPreventCornerOverlap, true);
        int defaultPadding = a.getDimensionPixelSize(R.styleable.HCardView_contentPadding, 0);
        this.mContentPadding.left = a.getDimensionPixelSize(R.styleable.HCardView_contentPaddingLeft, defaultPadding);
        this.mContentPadding.top = a.getDimensionPixelSize(R.styleable.HCardView_contentPaddingTop, defaultPadding);
        this.mContentPadding.right = a.getDimensionPixelSize(R.styleable.HCardView_contentPaddingRight, defaultPadding);
        this.mContentPadding.bottom = a.getDimensionPixelSize(R.styleable.HCardView_contentPaddingBottom, defaultPadding);
        if (elevation > maxElevation) {
            maxElevation = elevation;
        }
        this.mUserSetMinWidth = a.getDimensionPixelSize(R.styleable.HCardView_android_minWidth, 0);
        this.mUserSetMinHeight = a.getDimensionPixelSize(R.styleable.HCardView_android_minHeight, 0);
        a.recycle();
        IMPL.initialize(this.mCardViewDelegate, context, backgroundColor, radius, elevation, maxElevation, cardShadowStartColor, cardShadowEndColor);
    }

    public void setPadding(int left, int top, int right, int bottom) {
    }

    public void setPaddingRelative(int start, int top, int end, int bottom) {
    }

    public boolean getUseCompatPadding() {
        return this.mCompatPadding;
    }

    public void setUseCompatPadding(boolean useCompatPadding) {
        if (this.mCompatPadding != useCompatPadding) {
            this.mCompatPadding = useCompatPadding;
            IMPL.onCompatPaddingChanged(this.mCardViewDelegate);
        }
    }

    public void setContentPadding(@Px int left, @Px int top, @Px int right, @Px int bottom) {
        this.mContentPadding.set(left, top, right, bottom);
        IMPL.updatePadding(this.mCardViewDelegate);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (!(IMPL instanceof CardViewApi21Impl)) {
            int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            switch (widthMode) {
                case -2147483648: 
                case 0x40000000: {
                    int minWidth = (int)Math.ceil(IMPL.getMinWidth(this.mCardViewDelegate));
                    widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(minWidth, View.MeasureSpec.getSize((int)widthMeasureSpec)), (int)widthMode);
                    break;
                }
            }
            int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            switch (heightMode) {
                case -2147483648: 
                case 0x40000000: {
                    int minHeight = (int)Math.ceil(IMPL.getMinHeight(this.mCardViewDelegate));
                    heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(minHeight, View.MeasureSpec.getSize((int)heightMeasureSpec)), (int)heightMode);
                    break;
                }
            }
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public void setMinimumWidth(int minWidth) {
        this.mUserSetMinWidth = minWidth;
        super.setMinimumWidth(minWidth);
    }

    public void setMinimumHeight(int minHeight) {
        this.mUserSetMinHeight = minHeight;
        super.setMinimumHeight(minHeight);
    }

    public void setCardBackgroundColor(@ColorInt int color2) {
        IMPL.setBackgroundColor(this.mCardViewDelegate, ColorStateList.valueOf((int)color2));
    }

    public void setCardBackgroundColor(@Nullable ColorStateList color2) {
        IMPL.setBackgroundColor(this.mCardViewDelegate, color2);
    }

    @NonNull
    public ColorStateList getCardBackgroundColor() {
        return IMPL.getBackgroundColor(this.mCardViewDelegate);
    }

    @Px
    public int getContentPaddingLeft() {
        return this.mContentPadding.left;
    }

    @Px
    public int getContentPaddingRight() {
        return this.mContentPadding.right;
    }

    @Px
    public int getContentPaddingTop() {
        return this.mContentPadding.top;
    }

    @Px
    public int getContentPaddingBottom() {
        return this.mContentPadding.bottom;
    }

    public void setRadius(float radius) {
        IMPL.setRadius(this.mCardViewDelegate, radius);
    }

    public float getRadius() {
        return IMPL.getRadius(this.mCardViewDelegate);
    }

    public void setCardElevation(float elevation) {
        IMPL.setElevation(this.mCardViewDelegate, elevation);
    }

    public float getCardElevation() {
        return IMPL.getElevation(this.mCardViewDelegate);
    }

    public void setMaxCardElevation(float maxElevation) {
        IMPL.setMaxElevation(this.mCardViewDelegate, maxElevation);
    }

    public float getMaxCardElevation() {
        return IMPL.getMaxElevation(this.mCardViewDelegate);
    }

    public boolean getPreventCornerOverlap() {
        return this.mPreventCornerOverlap;
    }

    public void setPreventCornerOverlap(boolean preventCornerOverlap) {
        if (preventCornerOverlap != this.mPreventCornerOverlap) {
            this.mPreventCornerOverlap = preventCornerOverlap;
            IMPL.onPreventCornerOverlapChanged(this.mCardViewDelegate);
        }
    }

    static {
        COLOR_BACKGROUND_ATTR = new int[]{0x1010031};
        IMPL = new CardViewApi21Impl();
        IMPL.initStatic();
    }
}

