/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.edit;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Build;
import android.text.InputFilter;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.InflateException;
import android.view.View;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatEditText;
import com.zzh.lib.views.R;
import com.zzh.lib.views.listener.OnInputListener;
import java.lang.reflect.Field;

public class EditTextView
extends AppCompatEditText {
    public static final int CONTENT_SHOW_MODE_PASSWORD = 1;
    public static final int CONTENT_SHOW_MODE_TEXT = 2;
    public static final int INPUT_BOX_STYLE_CONNECT = 1;
    public static final int INPUT_BOX_STYLE_SINGLE = 2;
    public static final int INPUT_BOX_STYLE_UNDERLINE = 3;
    private RectF mRectFConnect;
    private RectF mRectFSingleBox;
    private Paint mPaintDivisionLine;
    private Paint mPaintContent;
    private Paint mPaintBorder;
    private Paint mPaintUnderline;
    private Float mBorderSize;
    private int mBorderColor;
    private float mCornerSize;
    private float mDivisionLineSize;
    private int mDivisionColor;
    private float mCircleRadius;
    private int mContentNumber;
    private int mContentShowMode;
    private float mSpaceSize;
    private int mInputBoxStyle;
    private float mTextSize;
    private int mTextColor;
    private boolean mInputBoxSquare;
    private OnInputListener inputListener;
    private Paint mPaintCursor;
    private CursorRunnable cursorRunnable;
    private int mCursorColor;
    private float mCursorWidth;
    private int mCursorHeight;
    private int mCursorDuration;
    private int mUnderlineFocusColor;
    private int mUnderlineNormalColor;

    public EditTextView(Context context) {
        this(context, null);
    }

    public EditTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EditTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs);
    }

    private void initAttrs(Context c, AttributeSet attrs) {
        TypedArray array = c.obtainStyledAttributes(attrs, R.styleable.SplitEditTextView);
        this.mBorderSize = Float.valueOf(array.getDimension(R.styleable.SplitEditTextView_borderSize, this.dp2px(1.0f)));
        this.mBorderColor = array.getColor(R.styleable.SplitEditTextView_borderColor, -16777216);
        this.mCornerSize = array.getDimension(R.styleable.SplitEditTextView_corner_size, 0.0f);
        this.mDivisionLineSize = array.getDimension(R.styleable.SplitEditTextView_divisionLineSize, this.dp2px(1.0f));
        this.mDivisionColor = array.getColor(R.styleable.SplitEditTextView_divisionLineColor, -16777216);
        this.mCircleRadius = array.getDimension(R.styleable.SplitEditTextView_circleRadius, this.dp2px(5.0f));
        this.mContentNumber = array.getInt(R.styleable.SplitEditTextView_contentNumber, 6);
        this.mContentShowMode = array.getInteger(R.styleable.SplitEditTextView_contentShowMode, 1);
        this.mInputBoxStyle = array.getInteger(R.styleable.SplitEditTextView_inputBoxStyle, 1);
        this.mSpaceSize = array.getDimension(R.styleable.SplitEditTextView_spaceSize, this.dp2px(10.0f));
        this.mTextSize = array.getDimension(R.styleable.SplitEditTextView_android_textSize, this.sp2px(16.0f));
        this.mTextColor = array.getColor(R.styleable.SplitEditTextView_android_textColor, -16777216);
        this.mInputBoxSquare = array.getBoolean(R.styleable.SplitEditTextView_inputBoxSquare, true);
        this.mCursorColor = array.getColor(R.styleable.SplitEditTextView_cursorColor, -16777216);
        this.mCursorDuration = array.getInt(R.styleable.SplitEditTextView_cursorDuration, 500);
        this.mCursorWidth = array.getDimension(R.styleable.SplitEditTextView_cursorWidth, this.dp2px(2.0f));
        this.mCursorHeight = (int)array.getDimension(R.styleable.SplitEditTextView_cursorHeight, 0.0f);
        this.mUnderlineNormalColor = array.getInt(R.styleable.SplitEditTextView_underlineNormalColor, -16777216);
        this.mUnderlineFocusColor = array.getInt(R.styleable.SplitEditTextView_underlineFocusColor, 0);
        array.recycle();
        this.init();
    }

    private void init() {
        this.mPaintBorder = new Paint(1);
        this.mPaintBorder.setStyle(Paint.Style.STROKE);
        this.mPaintBorder.setStrokeWidth(this.mBorderSize.floatValue());
        this.mPaintBorder.setColor(this.mBorderColor);
        this.mPaintDivisionLine = new Paint(1);
        this.mPaintDivisionLine.setStyle(Paint.Style.STROKE);
        this.mPaintDivisionLine.setStrokeWidth(this.mDivisionLineSize);
        this.mPaintDivisionLine.setColor(this.mDivisionColor);
        this.mPaintContent = new Paint(1);
        this.mPaintContent.setTextSize(this.mTextSize);
        this.mPaintCursor = new Paint(1);
        this.mPaintCursor.setStrokeWidth(this.mCursorWidth);
        this.mPaintCursor.setColor(this.mCursorColor);
        this.mPaintUnderline = new Paint(1);
        this.mPaintUnderline.setStrokeWidth(this.mBorderSize.floatValue());
        this.mPaintUnderline.setColor(this.mUnderlineNormalColor);
        this.mRectFSingleBox = new RectF();
        this.mRectFConnect = new RectF();
        this.setSingleLine();
        this.setFocusableInTouchMode(true);
        if (Build.VERSION.SDK_INT >= 29) {
            this.setTextSelectHandle(17170445);
        } else {
            try {
                Field f = TextView.class.getDeclaredField("mTextSelectHandleRes");
                f.setAccessible(true);
                f.set((Object)this, 17170445);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(this.mContentNumber)});
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.cursorRunnable = new CursorRunnable();
        this.postDelayed(this.cursorRunnable, this.mCursorDuration);
    }

    protected void onDetachedFromWindow() {
        this.removeCallbacks(this.cursorRunnable);
        super.onDetachedFromWindow();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mInputBoxSquare) {
            int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
            float itemWidth = this.getContentItemWidthOnMeasure(width);
            switch (this.mInputBoxStyle) {
                case 3: {
                    this.setMeasuredDimension(width, (int)(itemWidth + this.mBorderSize.floatValue()));
                    break;
                }
                default: {
                    this.setMeasuredDimension(width, (int)(itemWidth + this.mBorderSize.floatValue() * 2.0f));
                }
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        switch (this.mInputBoxStyle) {
            case 2: {
                this.drawSingleStyle(canvas);
                break;
            }
            case 3: {
                this.drawUnderlineStyle(canvas);
                break;
            }
            default: {
                this.drawConnectStyle(canvas);
            }
        }
        this.drawContent(canvas);
        this.drawCursor(canvas);
    }

    private void drawContent(Canvas canvas) {
        int cy = this.getHeight() / 2;
        String password = this.getText().toString().trim();
        if (this.mContentShowMode == 1) {
            this.mPaintContent.setColor(-16777216);
            for (int i = 0; i < password.length(); ++i) {
                float startX = this.getDrawContentStartX(i);
                canvas.drawCircle(startX, (float)cy, this.mCircleRadius, this.mPaintContent);
            }
        } else {
            this.mPaintContent.setColor(this.mTextColor);
            float baselineText = this.getTextBaseline(this.mPaintContent, cy);
            for (int i = 0; i < password.length(); ++i) {
                float startX = this.getDrawContentStartX(i);
                String text = String.valueOf(password.charAt(i));
                float textWidth = this.mPaintContent.measureText(text);
                canvas.drawText(text, startX - textWidth / 2.0f, baselineText, this.mPaintContent);
            }
        }
    }

    private void drawCursor(Canvas canvas) {
        if (this.mCursorHeight > this.getHeight()) {
            throw new InflateException("cursor height must smaller than view height");
        }
        String content = this.getText().toString().trim();
        float startX = this.getDrawContentStartX(content.length());
        if (this.mCursorHeight == 0) {
            this.mCursorHeight = this.getHeight() / 2;
        }
        int sy = (this.getHeight() - this.mCursorHeight) / 2;
        float startY = (float)sy + this.mBorderSize.floatValue();
        float stopY = (float)(this.getHeight() - sy) - this.mBorderSize.floatValue();
        canvas.drawLine(startX, startY, startX, stopY, this.mPaintCursor);
    }

    private float getDrawContentStartX(int index) {
        switch (this.mInputBoxStyle) {
            case 2: {
                return this.getContentItemWidth() / 2.0f + (float)index * this.getContentItemWidth() + (float)index * this.mSpaceSize + (float)(2 * index + 1) * this.mBorderSize.floatValue();
            }
            case 3: {
                return this.getContentItemWidth() / 2.0f + (float)index * this.mSpaceSize + (float)index * this.getContentItemWidth();
            }
        }
        return this.getContentItemWidth() / 2.0f + (float)index * this.getContentItemWidth() + (float)index * this.mDivisionLineSize + this.mBorderSize.floatValue();
    }

    private void drawUnderlineStyle(Canvas canvas) {
        String content = this.getText().toString().trim();
        for (int i = 0; i < this.mContentNumber; ++i) {
            float startX = (float)i * this.getContentItemWidth() + (float)i * this.mSpaceSize;
            float stopX = this.getContentItemWidth() + startX;
            float startY = (float)this.getHeight() - this.mBorderSize.floatValue() / 2.0f;
            if (this.mUnderlineFocusColor != 0) {
                if (content.length() >= i) {
                    this.mPaintUnderline.setColor(this.mUnderlineFocusColor);
                } else {
                    this.mPaintUnderline.setColor(this.mUnderlineNormalColor);
                }
            }
            canvas.drawLine(startX, startY, stopX, startY, this.mPaintUnderline);
        }
    }

    private void drawSingleStyle(Canvas canvas) {
        for (int i = 0; i < this.mContentNumber; ++i) {
            this.mRectFSingleBox.setEmpty();
            float left = (float)i * this.getContentItemWidth() + (float)i * this.mSpaceSize + (float)i * this.mBorderSize.floatValue() * 2.0f + this.mBorderSize.floatValue() / 2.0f;
            float right = (float)i * this.mSpaceSize + (float)(i + 1) * this.getContentItemWidth() + (float)((i + 1) * 2) * this.mBorderSize.floatValue() - this.mBorderSize.floatValue() / 2.0f;
            this.mRectFSingleBox.set(left, this.mBorderSize.floatValue() / 2.0f, right, (float)this.getHeight() - this.mBorderSize.floatValue() / 2.0f);
            canvas.drawRoundRect(this.mRectFSingleBox, this.mCornerSize, this.mCornerSize, this.mPaintBorder);
        }
    }

    private void drawConnectStyle(Canvas canvas) {
        this.mRectFConnect.setEmpty();
        this.mRectFConnect.set(this.mBorderSize.floatValue() / 2.0f, this.mBorderSize.floatValue() / 2.0f, (float)this.getWidth() - this.mBorderSize.floatValue() / 2.0f, (float)this.getHeight() - this.mBorderSize.floatValue() / 2.0f);
        canvas.drawRoundRect(this.mRectFConnect, this.mCornerSize, this.mCornerSize, this.mPaintBorder);
        this.drawDivisionLine(canvas);
    }

    private void drawDivisionLine(Canvas canvas) {
        float stopY = (float)this.getHeight() - this.mBorderSize.floatValue();
        for (int i = 0; i < this.mContentNumber - 1; ++i) {
            float startX = (float)(i + 1) * this.getContentItemWidth() + (float)i * this.mDivisionLineSize + this.mBorderSize.floatValue() + this.mDivisionLineSize / 2.0f;
            canvas.drawLine(startX, this.mBorderSize.floatValue(), startX, stopY, this.mPaintDivisionLine);
        }
    }

    private float getContentItemWidth() {
        float tempWidth;
        switch (this.mInputBoxStyle) {
            case 2: {
                tempWidth = (float)this.getWidth() - (float)(this.mContentNumber - 1) * this.mSpaceSize - (float)(2 * this.mContentNumber) * this.mBorderSize.floatValue();
                break;
            }
            case 3: {
                tempWidth = (float)this.getWidth() - (float)(this.mContentNumber - 1) * this.mSpaceSize;
                break;
            }
            default: {
                tempWidth = (float)this.getWidth() - this.mDivisionLineSize * (float)(this.mContentNumber - 1) - 2.0f * this.mBorderSize.floatValue();
            }
        }
        return tempWidth / (float)this.mContentNumber;
    }

    private float getContentItemWidthOnMeasure(int measureWidth) {
        float tempWidth;
        switch (this.mInputBoxStyle) {
            case 2: {
                tempWidth = (float)measureWidth - (float)(this.mContentNumber - 1) * this.mSpaceSize - (float)(2 * this.mContentNumber) * this.mBorderSize.floatValue();
                break;
            }
            case 3: {
                tempWidth = (float)measureWidth - (float)(this.mContentNumber - 1) * this.mSpaceSize;
                break;
            }
            default: {
                tempWidth = (float)measureWidth - this.mDivisionLineSize * (float)(this.mContentNumber - 1) - 2.0f * this.mBorderSize.floatValue();
            }
        }
        return tempWidth / (float)this.mContentNumber;
    }

    private float getTextBaseline(Paint paint, float halfHeight) {
        Paint.FontMetrics fontMetrics = paint.getFontMetrics();
        float dy = (fontMetrics.bottom - fontMetrics.top) / 2.0f - fontMetrics.bottom;
        return halfHeight + dy;
    }

    public void setContentShowMode(int mode) {
        if (mode != 1 && mode != 2) {
            throw new IllegalArgumentException("the value of the parameter must be one of{1:EDIT_SHOW_MODE_PASSWORD} or {2:EDIT_SHOW_MODE_TEXT}");
        }
        this.mContentShowMode = mode;
        this.invalidate();
    }

    public int getContentShowMode() {
        return this.mContentShowMode;
    }

    public void setInputBoxStyle(int inputBoxStyle) {
        if (inputBoxStyle != 1 && inputBoxStyle != 2 && inputBoxStyle != 3) {
            throw new IllegalArgumentException("the value of the parameter must be one of{1:INPUT_BOX_STYLE_CONNECT}, {2:INPUT_BOX_STYLE_SINGLE} or {3:INPUT_BOX_STYLE_UNDERLINE}");
        }
        this.mInputBoxStyle = inputBoxStyle;
        this.requestLayout();
    }

    public void setOnInputListener(OnInputListener listener) {
        this.inputListener = listener;
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        super.onTextChanged(text, start, lengthBefore, lengthAfter);
        String content = text.toString().trim();
        if (this.inputListener != null) {
            if (content.length() == this.mContentNumber) {
                this.inputListener.onInputFinished(content);
            } else {
                this.inputListener.onInputChanged(content);
            }
        }
    }

    public int getInputBoxStyle() {
        return this.mInputBoxStyle;
    }

    private float dp2px(float dpValue) {
        return TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    private float sp2px(float spValue) {
        return TypedValue.applyDimension((int)2, (float)spValue, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    private class CursorRunnable
    implements Runnable {
        private CursorRunnable() {
        }

        @Override
        public void run() {
            int alpha = EditTextView.this.mPaintCursor.getAlpha();
            EditTextView.this.mPaintCursor.setAlpha(alpha == 0 ? 255 : 0);
            EditTextView.this.invalidate();
            EditTextView.this.postDelayed(this, EditTextView.this.mCursorDuration);
        }
    }
}

