/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.gesture;

import android.content.Context;
import android.view.animation.Interpolator;
import android.widget.Scroller;

public class HScroller {
    private ScrollerApi mScrollerApi;
    private int mMaxScrollDistance;
    private int mMaxScrollDuration = 400;
    private int mMinScrollDuration = 200;
    private int mLastX;
    private int mLastY;
    private boolean mIsFinished = true;
    private Callback mCallback;

    public HScroller(Context context) {
        this(context, null);
    }

    public HScroller(Context context, Interpolator interpolator) {
        this(new SimpleScrollerApi(context, interpolator));
    }

    public HScroller(ScrollerApi scrollerApi) {
        this.setScrollerApi(scrollerApi);
    }

    public final boolean isFinished() {
        return this.mIsFinished;
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public void setScrollerApi(ScrollerApi scrollerApi) {
        if (scrollerApi == null) {
            throw new NullPointerException();
        }
        this.mScrollerApi = scrollerApi;
    }

    public final void setMaxScrollDistance(int distance) {
        this.mMaxScrollDistance = distance;
    }

    public final void setMaxScrollDuration(int duration) {
        this.mMaxScrollDuration = duration;
    }

    public final void setMinScrollDuration(int duration) {
        this.mMinScrollDuration = duration;
    }

    public final void setFriction(float friction) {
        this.mScrollerApi.setFriction(friction);
    }

    public final boolean scrollToX(int startX, int endX, int duration) {
        return this.scrollTo(startX, 0, endX, 0, duration);
    }

    public final boolean scrollToY(int startY, int endY, int duration) {
        return this.scrollTo(0, startY, 0, endY, duration);
    }

    public final boolean scrollTo(int startX, int startY, int endX, int endY, int duration) {
        int dx = endX - startX;
        int dy = endY - startY;
        return this.scrollDelta(startX, startY, dx, dy, duration);
    }

    public final boolean scrollDeltaX(int startX, int dx, int duration) {
        return this.scrollDelta(startX, 0, dx, 0, duration);
    }

    public final boolean scrollDeltaY(int startY, int dy, int duration) {
        return this.scrollDelta(0, startY, 0, dy, duration);
    }

    public final boolean scrollDelta(int startX, int startY, int dx, int dy, int duration) {
        boolean scroll;
        boolean bl = scroll = dx != 0 || dy != 0;
        if (scroll) {
            this.mLastX = startX;
            this.mLastY = startY;
            if (duration < 0) {
                duration = HScroller.computeDuration(dx, dy, this.mMaxScrollDistance, this.mMaxScrollDuration, this.mMinScrollDuration);
            }
            this.mScrollerApi.startScroll(startX, startY, dx, dy, duration);
            this.updateFinished();
        }
        return scroll;
    }

    public final boolean flingX(int startX, int velocityX, int minX, int maxX) {
        return this.fling(startX, 0, velocityX, 0, minX, maxX, 0, 0);
    }

    public final boolean flingY(int startY, int velocityY, int minY, int maxY) {
        return this.fling(0, startY, 0, velocityY, 0, 0, minY, maxY);
    }

    public final boolean fling(int startX, int startY, int velocityX, int velocityY, int minX, int maxX, int minY, int maxY) {
        boolean fling;
        boolean bl = fling = startX > minX && startX < maxX && velocityX != 0 || startY > minY && startY < maxY && velocityY != 0;
        if (fling) {
            this.mLastX = startX;
            this.mLastY = startY;
            this.mScrollerApi.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY);
            this.updateFinished();
        }
        return fling;
    }

    public final boolean computeScrollOffset() {
        boolean compute = this.mScrollerApi.computeScrollOffset();
        int currX = this.mScrollerApi.getCurrX();
        int currY = this.mScrollerApi.getCurrY();
        if (compute && (currX != this.mLastX || currY != this.mLastY)) {
            this.onScrollerCompute(this.mLastX, this.mLastY, currX, currY);
        }
        this.mLastX = currX;
        this.mLastY = currY;
        this.updateFinished();
        return compute;
    }

    public final boolean abortAnimation() {
        this.mScrollerApi.abortAnimation();
        return this.updateFinished(true);
    }

    private void updateFinished() {
        this.updateFinished(false);
    }

    private boolean updateFinished(boolean isAbort) {
        boolean finish = this.mScrollerApi.isFinished();
        if (this.mIsFinished == finish) {
            return false;
        }
        this.mIsFinished = finish;
        if (finish) {
            this.onScrollerFinish(isAbort);
        } else {
            this.onScrollerStart();
        }
        return true;
    }

    protected void onScrollerStart() {
        if (this.mCallback != null) {
            this.mCallback.onScrollerStart();
        }
    }

    protected void onScrollerCompute(int lastX, int lastY, int currX, int currY) {
        if (this.mCallback != null) {
            this.mCallback.onScrollerCompute(lastX, lastY, currX, currY);
        }
    }

    protected void onScrollerFinish(boolean isAbort) {
        if (this.mCallback != null) {
            this.mCallback.onScrollerFinish(isAbort);
        }
    }

    public static int computeDuration(int dx, int dy, int distanceMax, int durationMax, int durationMin) {
        durationMax = Math.abs(durationMax);
        durationMin = Math.abs(durationMin);
        if ((distanceMax = Math.abs(distanceMax)) == 0) {
            return durationMin;
        }
        if (durationMin > durationMax) {
            throw new IllegalArgumentException();
        }
        float distance = (float)Math.sqrt(Math.abs(dx * dx) + Math.abs(dy * dy));
        if (distance == 0.0f) {
            return 0;
        }
        float disPercent = distance / (float)distanceMax;
        int duration = (int)(disPercent * (float)durationMin + (float)durationMin);
        return Math.min(duration, durationMax);
    }

    private static class SimpleScrollerApi
    implements ScrollerApi {
        private final Scroller mScroller;

        public SimpleScrollerApi(Context context, Interpolator interpolator) {
            this.mScroller = new Scroller(context, interpolator);
        }

        @Override
        public void setFriction(float friction) {
            this.mScroller.setFriction(friction);
        }

        @Override
        public void startScroll(int startX, int startY, int dx, int dy, int duration) {
            this.mScroller.startScroll(startX, startY, dx, dy, duration);
        }

        @Override
        public void fling(int startX, int startY, int velocityX, int velocityY, int minX, int maxX, int minY, int maxY) {
            this.mScroller.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY);
        }

        @Override
        public boolean computeScrollOffset() {
            return this.mScroller.computeScrollOffset();
        }

        @Override
        public void abortAnimation() {
            this.mScroller.abortAnimation();
        }

        @Override
        public boolean isFinished() {
            return this.mScroller.isFinished();
        }

        @Override
        public int getCurrX() {
            return this.mScroller.getCurrX();
        }

        @Override
        public int getCurrY() {
            return this.mScroller.getCurrY();
        }
    }

    public static interface ScrollerApi {
        public void setFriction(float var1);

        public void startScroll(int var1, int var2, int var3, int var4, int var5);

        public void fling(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

        public boolean computeScrollOffset();

        public void abortAnimation();

        public boolean isFinished();

        public int getCurrX();

        public int getCurrY();
    }

    public static interface Callback {
        public void onScrollerStart();

        public void onScrollerCompute(int var1, int var2, int var3, int var4);

        public void onScrollerFinish(boolean var1);
    }
}

