/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.indicators;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.animation.LinearInterpolator;
import com.zzh.lib.views.def.Indicator;
import java.util.ArrayList;

public class PacmanIndicator
extends Indicator {
    private float translateX;
    private int alpha;
    private float degrees1;
    private float degrees2;

    @Override
    public void draw(Canvas canvas, Paint paint) {
        this.drawPacman(canvas, paint);
        this.drawCircle(canvas, paint);
    }

    private void drawPacman(Canvas canvas, Paint paint) {
        float x = this.getWidth() / 2;
        float y = this.getHeight() / 2;
        canvas.save();
        canvas.translate(x, y);
        canvas.rotate(this.degrees1);
        paint.setAlpha(255);
        RectF rectF1 = new RectF(-x / 1.7f, -y / 1.7f, x / 1.7f, y / 1.7f);
        canvas.drawArc(rectF1, 0.0f, 270.0f, true, paint);
        canvas.restore();
        canvas.save();
        canvas.translate(x, y);
        canvas.rotate(this.degrees2);
        paint.setAlpha(255);
        RectF rectF2 = new RectF(-x / 1.7f, -y / 1.7f, x / 1.7f, y / 1.7f);
        canvas.drawArc(rectF2, 90.0f, 270.0f, true, paint);
        canvas.restore();
    }

    private void drawCircle(Canvas canvas, Paint paint) {
        float radius = this.getWidth() / 11;
        paint.setAlpha(this.alpha);
        canvas.drawCircle(this.translateX, (float)(this.getHeight() / 2), radius, paint);
    }

    @Override
    public ArrayList<ValueAnimator> onCreateAnimators() {
        ArrayList<ValueAnimator> animators = new ArrayList<ValueAnimator>();
        float startT = this.getWidth() / 11;
        ValueAnimator translationAnim = ValueAnimator.ofFloat((float[])new float[]{(float)this.getWidth() - startT, this.getWidth() / 2});
        translationAnim.setDuration(650L);
        translationAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
        translationAnim.setRepeatCount(-1);
        this.addUpdateListener(translationAnim, new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                PacmanIndicator.this.translateX = ((Float)animation.getAnimatedValue()).floatValue();
                PacmanIndicator.this.postInvalidate();
            }
        });
        ValueAnimator alphaAnim = ValueAnimator.ofInt((int[])new int[]{255, 122});
        alphaAnim.setDuration(650L);
        alphaAnim.setRepeatCount(-1);
        this.addUpdateListener(alphaAnim, new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                PacmanIndicator.this.alpha = (Integer)animation.getAnimatedValue();
                PacmanIndicator.this.postInvalidate();
            }
        });
        ValueAnimator rotateAnim1 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 45.0f, 0.0f});
        rotateAnim1.setDuration(650L);
        rotateAnim1.setRepeatCount(-1);
        this.addUpdateListener(rotateAnim1, new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                PacmanIndicator.this.degrees1 = ((Float)animation.getAnimatedValue()).floatValue();
                PacmanIndicator.this.postInvalidate();
            }
        });
        ValueAnimator rotateAnim2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, -45.0f, 0.0f});
        rotateAnim2.setDuration(650L);
        rotateAnim2.setRepeatCount(-1);
        this.addUpdateListener(rotateAnim2, new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                PacmanIndicator.this.degrees2 = ((Float)animation.getAnimatedValue()).floatValue();
                PacmanIndicator.this.postInvalidate();
            }
        });
        animators.add(translationAnim);
        animators.add(alphaAnim);
        animators.add(rotateAnim1);
        animators.add(rotateAnim2);
        return animators;
    }
}

