/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.progressbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import com.zzh.lib.views.R;

public class AbsProgressBar
extends View {
    protected Context context;
    protected Paint paint;
    protected float width;
    protected float height;
    protected int backgroundColor;
    protected int textColor;
    protected int progress;
    protected int maxProgress;

    public AbsProgressBar(Context context) {
        super(context);
        this.context = context;
        this.initPaint();
    }

    public AbsProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.init(context, attrs);
        this.initPaint();
    }

    public AbsProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.init(context, attrs);
        this.initPaint();
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.HAbsProgressBar);
        this.progress = a.getInteger(R.styleable.HAbsProgressBar_zh_progress, 0);
        this.backgroundColor = a.getColor(R.styleable.HAbsProgressBar_zh_background_color, -723724);
        this.textColor = a.getColor(R.styleable.HAbsProgressBar_zh_text_color, -1);
        this.maxProgress = a.getInteger(R.styleable.HAbsProgressBar_zh_max_progress, 100);
        this.setProgress(this.progress);
        a.recycle();
    }

    protected void initPaint() {
        if (this.paint == null) {
            this.paint = new Paint();
        } else {
            this.paint.reset();
        }
        this.paint.setAntiAlias(true);
    }

    protected void getDimension() {
        this.width = this.getMeasuredWidth();
        this.height = this.getMeasuredHeight();
    }

    protected void onDraw(Canvas canvas) {
        this.getDimension();
        int saveCount = canvas.save();
        this.drawProgress(canvas);
        this.drawText(canvas);
        canvas.restoreToCount(saveCount);
    }

    public void drawProgress(Canvas canvas) {
    }

    public void drawText(Canvas canvas) {
    }

    public float dip2px(float dpValue) {
        float scale = this.context.getResources().getDisplayMetrics().density;
        return dpValue * scale + 0.5f;
    }

    public void setProgress(int progress) {
        this.progress = Math.min(progress, this.maxProgress);
        this.invalidate();
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }
}

