/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.progressbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.zzh.lib.views.R;
import com.zzh.lib.views.progressbar.HProgressBar;

public class HFloatTextProgressBar
extends HProgressBar {
    private float progressHeight;
    private float floatRectWidth;
    private float floatRectHeight;
    private float triangleWidth;
    private float margin;
    private float textSize;
    private int triangleColor;
    private int rectColor;
    protected int fillColor;

    public HFloatTextProgressBar(Context context) {
        super(context);
    }

    public HFloatTextProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public HFloatTextProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @Override
    protected void getDimension() {
        super.getDimension();
        this.progressHeight = this.height / 5.0f;
        this.floatRectWidth = this.height / 5.0f * 4.0f;
        this.floatRectHeight = this.height / 9.0f * 4.0f;
        this.triangleWidth = this.height / 7.0f * 2.0f;
        this.margin = this.dip2px(3.0f);
        this.textSize = this.height / 4.0f;
    }

    private void init(AttributeSet attrs) {
        TypedArray a = this.context.obtainStyledAttributes(attrs, R.styleable.HFloatTextProgressBar);
        this.fillColor = a.getColor(R.styleable.HFloatTextProgressBar_zh_fill_color, -65536);
        this.triangleColor = a.getColor(R.styleable.HFloatTextProgressBar_zh_triangle_color, -65536);
        this.rectColor = a.getColor(R.styleable.HFloatTextProgressBar_zh_rect_color, -65536);
        a.recycle();
    }

    @Override
    public void drawProgress(Canvas canvas) {
        this.paint.setColor(this.backgroundColor);
        RectF backgroundRectF = new RectF(0.0f, this.height - this.progressHeight, this.width, this.height);
        canvas.drawRoundRect(backgroundRectF, this.progressHeight / 2.0f, this.progressHeight / 2.0f, this.paint);
        this.paint.setColor(this.fillColor);
        RectF fillRectF = new RectF(0.0f, this.height - this.progressHeight, this.progressWidth, this.height);
        canvas.drawRoundRect(fillRectF, this.progressHeight / 2.0f, this.progressHeight / 2.0f, this.paint);
        this.drawFloatRect(canvas);
    }

    private void drawFloatRect(Canvas canvas) {
        if (this.progressWidth < this.floatRectWidth + this.margin) {
            this.paint.setColor(this.rectColor);
            RectF floatRectF = new RectF(this.margin, 0.0f, this.margin + this.floatRectWidth, this.floatRectHeight);
            canvas.drawRoundRect(floatRectF, this.dip2px(2.0f), this.dip2px(2.0f), this.paint);
            this.paint.setColor(this.triangleColor);
            Path path = new Path();
            path.moveTo(this.margin + this.floatRectWidth / 2.0f - this.triangleWidth / 2.0f, this.height / 7.0f * 3.0f);
            path.lineTo(this.margin + this.floatRectWidth / 2.0f + this.triangleWidth / 2.0f, this.height / 7.0f * 3.0f);
            path.lineTo(this.margin + this.floatRectWidth / 2.0f, this.floatRectWidth / 4.0f + this.height / 7.0f * 3.0f);
            path.close();
            canvas.drawPath(path, this.paint);
        } else if (this.width - this.progressWidth < this.floatRectWidth + this.margin) {
            this.paint.setColor(this.rectColor);
            RectF floatRectF = new RectF(this.width - this.floatRectWidth - this.margin, 0.0f, this.width - this.margin, this.floatRectHeight);
            canvas.drawRoundRect(floatRectF, this.dip2px(2.0f), this.dip2px(2.0f), this.paint);
            this.paint.setColor(this.triangleColor);
            Path path = new Path();
            path.moveTo(this.width - this.margin - this.floatRectWidth / 2.0f - this.triangleWidth / 2.0f, this.height / 7.0f * 3.0f);
            path.lineTo(this.width - this.margin - this.floatRectWidth / 2.0f + this.triangleWidth / 2.0f, this.height / 7.0f * 3.0f);
            path.lineTo(this.width - this.margin - this.floatRectWidth / 2.0f, this.floatRectWidth / 4.0f + this.height / 7.0f * 3.0f);
            path.close();
            canvas.drawPath(path, this.paint);
        } else {
            this.paint.setColor(this.rectColor);
            RectF floatRectF = new RectF(this.progressWidth - this.floatRectWidth / 2.0f, 0.0f, this.progressWidth + this.floatRectWidth / 2.0f, this.floatRectHeight);
            canvas.drawRoundRect(floatRectF, this.dip2px(2.0f), this.dip2px(2.0f), this.paint);
            this.paint.setColor(this.triangleColor);
            Path path = new Path();
            path.moveTo(this.progressWidth - this.triangleWidth / 2.0f, this.height / 7.0f * 3.0f);
            path.lineTo(this.progressWidth + this.triangleWidth / 2.0f, this.height / 7.0f * 3.0f);
            path.lineTo(this.progressWidth, this.floatRectWidth / 4.0f + this.height / 7.0f * 3.0f);
            path.close();
            canvas.drawPath(path, this.paint);
        }
    }

    @Override
    public void drawText(Canvas canvas) {
        this.paint.setColor(this.textColor);
        this.paint.setTextSize(this.textSize);
        String progressText = (float)this.progress * 100.0f / (float)this.maxProgress + "%";
        float textWidth = this.paint.measureText(progressText);
        if (this.progressWidth < this.floatRectWidth + this.margin) {
            canvas.drawText(progressText, this.margin + this.floatRectWidth / 2.0f - textWidth / 2.0f, this.floatRectHeight / 2.0f + this.textSize / 4.0f, this.paint);
        } else if (this.width - this.progressWidth < this.floatRectWidth + this.margin) {
            canvas.drawText(progressText, this.width - this.margin - this.floatRectWidth / 2.0f - textWidth / 2.0f, this.floatRectHeight / 2.0f + this.textSize / 4.0f, this.paint);
        } else {
            canvas.drawText(progressText, this.progressWidth - textWidth / 2.0f, this.floatRectHeight / 2.0f + this.textSize / 4.0f, this.paint);
        }
    }

    public void setFillColor(int fillColor) {
        this.fillColor = fillColor;
    }

    public void setRectColor(int rectColor) {
        this.rectColor = rectColor;
    }

    public void setTriangleColor(int triangleColor) {
        this.triangleColor = triangleColor;
    }
}

