/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.refresh.loading;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.TextView;
import com.zzh.lib.views.HLoadingIndicatorView;
import com.zzh.lib.views.R;
import com.zzh.lib.views.def.PullToRefreshView;
import com.zzh.lib.views.refresh.loading.BaseLoadingView;

public class SimpleTextLoadingView
extends BaseLoadingView {
    private TextView tv_content;
    private HLoadingIndicatorView hliv;

    public SimpleTextLoadingView(Context context) {
        super(context);
        this.init();
    }

    public SimpleTextLoadingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SimpleTextLoadingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.h_ptr_view_simple_text_loading, (ViewGroup)this, true);
        this.tv_content = (TextView)this.findViewById(R.id.tv_content);
        this.hliv = (HLoadingIndicatorView)this.findViewById(R.id.hliv);
    }

    public TextView getTextView() {
        return this.tv_content;
    }

    public HLoadingIndicatorView getLoadingIndicatorView() {
        return this.hliv;
    }

    @Override
    public void onStateChanged(PullToRefreshView.State oldState, PullToRefreshView.State newState, PullToRefreshView view) {
        switch (newState) {
            case RESET: 
            case PULL_TO_REFRESH: {
                if (this == this.getPullToRefreshView().getHeaderView()) {
                    this.getTextView().setText((CharSequence)this.getResources().getString(R.string.zh_ptr_state_pull_to_refresh_header));
                    break;
                }
                if (this != this.getPullToRefreshView().getFooterView()) break;
                this.getTextView().setText((CharSequence)this.getResources().getString(R.string.zh_ptr_state_pull_to_refresh_footer));
                break;
            }
            case RELEASE_TO_REFRESH: {
                if (this == this.getPullToRefreshView().getHeaderView()) {
                    this.getTextView().setText((CharSequence)this.getResources().getString(R.string.zh_ptr_state_release_to_refresh_header));
                    break;
                }
                if (this != this.getPullToRefreshView().getFooterView()) break;
                this.getTextView().setText((CharSequence)this.getResources().getString(R.string.zh_ptr_state_release_to_refresh_footer));
                break;
            }
            case REFRESHING: {
                if (this == this.getPullToRefreshView().getHeaderView()) {
                    this.getTextView().setText((CharSequence)this.getResources().getString(R.string.zh_ptr_state_refreshing_header));
                    break;
                }
                if (this != this.getPullToRefreshView().getFooterView()) break;
                this.getTextView().setText((CharSequence)this.getResources().getString(R.string.zh_ptr_state_refreshing_footer));
                break;
            }
            case REFRESHING_SUCCESS: {
                if (this == this.getPullToRefreshView().getHeaderView()) {
                    this.getTextView().setText((CharSequence)this.getResources().getString(R.string.zh_ptr_state_refreshing_success_header));
                    break;
                }
                if (this != this.getPullToRefreshView().getFooterView()) break;
                this.getTextView().setText((CharSequence)this.getResources().getString(R.string.zh_ptr_state_refreshing_success_footer));
                break;
            }
            case REFRESHING_FAILURE: {
                if (this == this.getPullToRefreshView().getHeaderView()) {
                    this.getTextView().setText((CharSequence)this.getResources().getString(R.string.zh_ptr_state_refreshing_failure_header));
                    break;
                }
                if (this != this.getPullToRefreshView().getFooterView()) break;
                this.getTextView().setText((CharSequence)this.getResources().getString(R.string.zh_ptr_state_refreshing_failure_footer));
                break;
            }
            case FINISH: {
                if (oldState != PullToRefreshView.State.REFRESHING) break;
                if (this == this.getPullToRefreshView().getHeaderView()) {
                    this.getTextView().setText((CharSequence)this.getResources().getString(R.string.zh_ptr_state_pull_to_refresh_header));
                    break;
                }
                if (this != this.getPullToRefreshView().getFooterView()) break;
                this.getTextView().setText((CharSequence)this.getResources().getString(R.string.zh_ptr_state_pull_to_refresh_footer));
            }
        }
    }
}

