/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.shine;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PathMeasure;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import com.zzh.lib.views.HTagFlowLayout;
import com.zzh.lib.views.R;
import com.zzh.lib.views.def.OnAnimationEndListener;

public class HFollowGiftView
extends View {
    private float rectRadius = 0.0f;
    private RectF rect = new RectF();
    private Paint rectPaint = new Paint();
    private Paint plusPaint = new Paint();
    private float plusLineWidth = 0.0f;
    private Path plusPath = new Path();
    private Paint okPaint = new Paint();
    private float okLineWidth = 0.0f;
    private Path okPath = new Path();
    private PathMeasure pathMeasure = null;
    private boolean startDrawOk = false;
    private ValueAnimator animatorDrawOk = null;
    private PathEffect effect = null;
    private boolean isAnimating = false;
    private int fillColor = -1179567;

    public HFollowGiftView(Context context) {
        super(context);
        this.init(context);
    }

    public HFollowGiftView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.HFollowGiftView);
        if (a.hasValue(R.styleable.HFollowGiftView_zh_fill_color)) {
            this.fillColor = a.getColor(R.styleable.HFollowGiftView_zh_fill_color, -1179567);
        }
        a.recycle();
        this.init(context);
    }

    public HFollowGiftView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.HFollowGiftView);
        if (a.hasValue(R.styleable.HFollowGiftView_zh_fill_color)) {
            this.fillColor = a.getColor(R.styleable.HFollowGiftView_zh_fill_color, -1179567);
        }
        a.recycle();
        this.init(context);
    }

    private void init(Context context) {
        this.rectRadius = HTagFlowLayout.dip2px(context, 15.0f);
        this.plusLineWidth = HTagFlowLayout.dip2px(context, 2.0f);
        this.rectPaint.setAntiAlias(true);
        this.rectPaint.setColor(this.fillColor);
        this.rectPaint.setStyle(Paint.Style.FILL);
        this.plusPaint.setAntiAlias(true);
        this.plusPaint.setColor(-1);
        this.plusPaint.setStyle(Paint.Style.STROKE);
        this.plusPaint.setStrokeWidth(this.plusLineWidth);
        this.okLineWidth = HTagFlowLayout.dip2px(context, 2.5f);
        this.okPaint.setAntiAlias(true);
        this.okPaint.setColor(this.fillColor);
        this.okPaint.setStyle(Paint.Style.STROKE);
        this.okPaint.setStrokeWidth(this.okLineWidth);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        float plusSize = (float)this.getMeasuredHeight() * 0.6f;
        this.plusPath.moveTo((float)this.getMeasuredWidth() / 2.0f, ((float)this.getMeasuredHeight() - plusSize) / 2.0f);
        this.plusPath.lineTo((float)this.getMeasuredWidth() / 2.0f, ((float)this.getMeasuredHeight() + plusSize) / 2.0f);
        this.plusPath.moveTo(((float)this.getMeasuredWidth() - plusSize) / 2.0f, (float)this.getMeasuredHeight() / 2.0f);
        this.plusPath.lineTo(((float)this.getMeasuredWidth() + plusSize) / 2.0f, (float)this.getMeasuredHeight() / 2.0f);
        this.okPath.moveTo((float)this.getMeasuredWidth() * 0.31f, (float)this.getMeasuredHeight() * 0.5f);
        this.okPath.lineTo((float)this.getMeasuredWidth() * 0.45f, (float)this.getMeasuredHeight() * 0.75f);
        this.okPath.lineTo((float)this.getMeasuredWidth() * 0.68f, (float)this.getMeasuredHeight() * 0.25f);
        this.pathMeasure = new PathMeasure(this.okPath, true);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.rect.set(0.0f, 0.0f, (float)this.getMeasuredWidth(), (float)this.getMeasuredHeight());
        if (this.startDrawOk) {
            this.rectPaint.setColor(-1);
            canvas.drawRoundRect(this.rect, this.rectRadius, this.rectRadius, this.rectPaint);
            canvas.drawPath(this.okPath, this.okPaint);
        } else {
            this.rectPaint.setColor(this.fillColor);
            canvas.drawRoundRect(this.rect, this.rectRadius, this.rectRadius, this.rectPaint);
            canvas.drawPath(this.plusPath, this.plusPaint);
        }
    }

    public void startFollowAnimation(final OnAnimationEndListener animationEnd) {
        this.isAnimating = true;
        ScaleAnimation startScaleAnimation = new ScaleAnimation(1.0f, 1.2f, 1.0f, 1.2f, 1, 0.5f, 1, 0.5f);
        startScaleAnimation.setDuration(300L);
        startScaleAnimation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                HFollowGiftView.this.startDrawOk = true;
                HFollowGiftView.this.animatorDrawOk = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
                HFollowGiftView.this.animatorDrawOk.setDuration(1000L);
                HFollowGiftView.this.animatorDrawOk.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        float value = ((Float)animation.getAnimatedValue()).floatValue();
                        HFollowGiftView.this.effect = new DashPathEffect(new float[]{HFollowGiftView.this.pathMeasure.getLength(), HFollowGiftView.this.pathMeasure.getLength()}, value * HFollowGiftView.this.pathMeasure.getLength());
                        HFollowGiftView.this.okPaint.setPathEffect(HFollowGiftView.this.effect);
                        HFollowGiftView.this.invalidate();
                    }
                });
                HFollowGiftView.this.animatorDrawOk.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        AnimationSet animationSet = new AnimationSet(true);
                        AlphaAnimation alphaAnimation = new AlphaAnimation(1.0f, 0.2f);
                        ScaleAnimation scaleAnimation = new ScaleAnimation(1.0f, 0.2f, 1.0f, 0.2f, 1, 0.5f, 1, 0.5f);
                        animationSet.addAnimation((Animation)alphaAnimation);
                        animationSet.addAnimation((Animation)scaleAnimation);
                        animationSet.setDuration(300L);
                        animationSet.setInterpolator((Interpolator)new AccelerateInterpolator());
                        animationSet.setAnimationListener(new Animation.AnimationListener(){

                            public void onAnimationStart(Animation animation) {
                            }

                            public void onAnimationEnd(Animation animation) {
                                HFollowGiftView.this.startDrawOk = false;
                                HFollowGiftView.this.isAnimating = false;
                                animationEnd.onAnimationEnd();
                            }

                            public void onAnimationRepeat(Animation animation) {
                            }
                        });
                        HFollowGiftView.this.startAnimation((Animation)animationSet);
                    }
                });
                HFollowGiftView.this.animatorDrawOk.start();
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.startAnimation((Animation)startScaleAnimation);
    }

    public boolean isAnimating() {
        return this.isAnimating;
    }
}

