/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.shine;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import com.zzh.lib.views.interpolator.EasingInterpolator;
import com.zzh.lib.views.shine.ShineAnimator;
import com.zzh.lib.views.shine.ShineImageView;
import com.zzh.lib.views.shine.listener.SimpleAnimatorListener;
import com.zzh.lib.views.utils.Ease;
import java.util.Random;

public class ShineView
extends View {
    private static final String TAG = "ShineView";
    private static final long FRAME_REFRESH_DELAY = 25L;
    ShineAnimator shineAnimator;
    ValueAnimator clickAnimator;
    ShineImageView shineButton;
    private Paint paint;
    private Paint paint2;
    private Paint paintSmall;
    int colorCount = 10;
    static int[] colorRandom = new int[10];
    int shineCount;
    float smallOffsetAngle;
    float turnAngle;
    long animDuration;
    long clickAnimDuration;
    float shineDistanceMultiple;
    int smallShineColor = colorRandom[0];
    int bigShineColor = colorRandom[1];
    int shineSize = 0;
    boolean allowRandomColor = false;
    boolean enableFlashing = false;
    RectF rectF = new RectF();
    RectF rectFSmall = new RectF();
    Random random = new Random();
    int centerAnimX;
    int centerAnimY;
    int btnWidth;
    int btnHeight;
    double thirdLength;
    float value;
    float clickValue = 0.0f;
    boolean isRun = false;
    private final float distanceOffset = 0.2f;

    public ShineView(Context context) {
        super(context);
    }

    public ShineView(Context context, final ShineImageView shineButton, ShineParams shineParams) {
        super(context);
        this.initShineParams(shineParams, shineButton);
        this.shineAnimator = new ShineAnimator(this.animDuration, this.shineDistanceMultiple, this.clickAnimDuration);
        ValueAnimator.setFrameDelay((long)25L);
        this.shineButton = shineButton;
        this.paint = new Paint();
        this.paint.setColor(this.bigShineColor);
        this.paint.setStrokeWidth(20.0f);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeCap(Paint.Cap.ROUND);
        this.paint2 = new Paint();
        this.paint2.setColor(-1);
        this.paint2.setStrokeWidth(20.0f);
        this.paint2.setStrokeCap(Paint.Cap.ROUND);
        this.paintSmall = new Paint();
        this.paintSmall.setColor(this.smallShineColor);
        this.paintSmall.setStrokeWidth(10.0f);
        this.paintSmall.setStyle(Paint.Style.STROKE);
        this.paintSmall.setStrokeCap(Paint.Cap.ROUND);
        this.clickAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.1f});
        ValueAnimator.setFrameDelay((long)25L);
        this.clickAnimator.setDuration(this.clickAnimDuration);
        this.clickAnimator.setInterpolator((TimeInterpolator)new EasingInterpolator(Ease.QUART_OUT));
        this.clickAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ShineView.this.clickValue = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                ShineView.this.invalidate();
            }
        });
        this.clickAnimator.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animator) {
                ShineView.this.clickValue = 0.0f;
                ShineView.this.invalidate();
            }
        });
        this.shineAnimator.addListener(new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animator) {
                shineButton.removeView(ShineView.this);
            }
        });
    }

    public ShineView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ShineView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void showAnimation(ShineImageView shineButton) {
        this.btnWidth = shineButton.getWidth();
        this.btnHeight = shineButton.getHeight();
        this.thirdLength = this.getThirdLength(this.btnHeight, this.btnWidth);
        int[] location = new int[2];
        shineButton.getLocationInWindow(location);
        this.centerAnimX = location[0] + shineButton.getWidth() / 2;
        this.centerAnimY = location[1] + shineButton.getHeight() / 2;
        if (shineButton.mFixDialog != null && shineButton.mFixDialog.getWindow() != null) {
            View decor = shineButton.mFixDialog.getWindow().getDecorView();
            this.centerAnimX -= decor.getPaddingLeft();
            this.centerAnimY -= decor.getPaddingTop();
        }
        this.shineAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ShineView.this.value = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                if (ShineView.this.shineSize != 0 && ShineView.this.shineSize > 0) {
                    ShineView.this.paint.setStrokeWidth((float)ShineView.this.shineSize * (ShineView.this.shineDistanceMultiple - ShineView.this.value));
                    ShineView.this.paintSmall.setStrokeWidth((float)ShineView.this.shineSize / 3.0f * 2.0f * (ShineView.this.shineDistanceMultiple - ShineView.this.value));
                } else {
                    ShineView.this.paint.setStrokeWidth((float)(ShineView.this.btnWidth / 2) * (ShineView.this.shineDistanceMultiple - ShineView.this.value));
                    ShineView.this.paintSmall.setStrokeWidth((float)(ShineView.this.btnWidth / 3) * (ShineView.this.shineDistanceMultiple - ShineView.this.value));
                }
                ShineView.this.rectF.set((float)ShineView.this.centerAnimX - (float)ShineView.this.btnWidth / (3.0f - ShineView.this.shineDistanceMultiple) * ShineView.this.value, (float)ShineView.this.centerAnimY - (float)ShineView.this.btnHeight / (3.0f - ShineView.this.shineDistanceMultiple) * ShineView.this.value, (float)ShineView.this.centerAnimX + (float)ShineView.this.btnWidth / (3.0f - ShineView.this.shineDistanceMultiple) * ShineView.this.value, (float)ShineView.this.centerAnimY + (float)ShineView.this.btnHeight / (3.0f - ShineView.this.shineDistanceMultiple) * ShineView.this.value);
                ShineView.this.rectFSmall.set((float)ShineView.this.centerAnimX - (float)ShineView.this.btnWidth / (3.0f - ShineView.this.shineDistanceMultiple + 0.2f) * ShineView.this.value, (float)ShineView.this.centerAnimY - (float)ShineView.this.btnHeight / (3.0f - ShineView.this.shineDistanceMultiple + 0.2f) * ShineView.this.value, (float)ShineView.this.centerAnimX + (float)ShineView.this.btnWidth / (3.0f - ShineView.this.shineDistanceMultiple + 0.2f) * ShineView.this.value, (float)ShineView.this.centerAnimY + (float)ShineView.this.btnHeight / (3.0f - ShineView.this.shineDistanceMultiple + 0.2f) * ShineView.this.value);
                ShineView.this.invalidate();
            }
        });
        this.shineAnimator.startAnim();
        this.clickAnimator.start();
    }

    protected void onDraw(Canvas canvas) {
        int i;
        super.onDraw(canvas);
        for (i = 0; i < this.shineCount; ++i) {
            if (this.allowRandomColor) {
                this.paint.setColor(colorRandom[Math.abs(this.colorCount / 2 - i) >= this.colorCount ? this.colorCount - 1 : Math.abs(this.colorCount / 2 - i)]);
            }
            canvas.drawArc(this.rectF, 360.0f / (float)this.shineCount * (float)i + 1.0f + (this.value - 1.0f) * this.turnAngle, 0.1f, false, this.getConfigPaint(this.paint));
        }
        for (i = 0; i < this.shineCount; ++i) {
            if (this.allowRandomColor) {
                this.paint.setColor(colorRandom[Math.abs(this.colorCount / 2 - i) >= this.colorCount ? this.colorCount - 1 : Math.abs(this.colorCount / 2 - i)]);
            }
            canvas.drawArc(this.rectFSmall, 360.0f / (float)this.shineCount * (float)i + 1.0f - this.smallOffsetAngle + (this.value - 1.0f) * this.turnAngle, 0.1f, false, this.getConfigPaint(this.paintSmall));
        }
        this.paint.setStrokeWidth((float)this.btnWidth * this.clickValue * (this.shineDistanceMultiple - 0.2f));
        if (this.clickValue != 0.0f) {
            this.paint2.setStrokeWidth((float)this.btnWidth * this.clickValue * (this.shineDistanceMultiple - 0.2f) - 8.0f);
        } else {
            this.paint2.setStrokeWidth(0.0f);
        }
        canvas.drawPoint((float)this.centerAnimX, (float)this.centerAnimY, this.paint);
        canvas.drawPoint((float)this.centerAnimX, (float)this.centerAnimY, this.paint2);
        if (this.shineAnimator != null && !this.isRun) {
            this.isRun = true;
            this.showAnimation(this.shineButton);
        }
    }

    private Paint getConfigPaint(Paint paint) {
        if (this.enableFlashing) {
            paint.setColor(colorRandom[this.random.nextInt(this.colorCount - 1)]);
        }
        return paint;
    }

    private double getThirdLength(int btnHeight, int btnWidth) {
        int all = btnHeight * btnHeight + btnWidth * btnWidth;
        return Math.sqrt(all);
    }

    private void initShineParams(ShineParams shineParams, ShineImageView shineButton) {
        this.shineCount = shineParams.shineCount;
        this.turnAngle = shineParams.shineTurnAngle;
        this.smallOffsetAngle = shineParams.smallShineOffsetAngle;
        this.enableFlashing = shineParams.enableFlashing;
        this.allowRandomColor = shineParams.allowRandomColor;
        this.shineDistanceMultiple = shineParams.shineDistanceMultiple;
        this.animDuration = shineParams.animDuration;
        this.clickAnimDuration = shineParams.clickAnimDuration;
        this.smallShineColor = shineParams.smallShineColor;
        this.bigShineColor = shineParams.bigShineColor;
        this.shineSize = shineParams.shineSize;
        if (this.smallShineColor == 0) {
            this.smallShineColor = colorRandom[6];
        }
        if (this.bigShineColor == 0) {
            this.bigShineColor = shineButton.getColor();
        }
    }

    public static class ShineParams {
        public boolean allowRandomColor = false;
        public long animDuration = 1500L;
        public int bigShineColor = 0;
        public long clickAnimDuration = 200L;
        public boolean enableFlashing = false;
        public int shineCount = 7;
        public float shineTurnAngle = 20.0f;
        public float shineDistanceMultiple = 1.5f;
        public float smallShineOffsetAngle = 20.0f;
        public int smallShineColor = 0;
        public int shineSize = 0;

        ShineParams() {
            ShineView.colorRandom[0] = Color.parseColor((String)"#FFFF99");
            ShineView.colorRandom[1] = Color.parseColor((String)"#FFCCCC");
            ShineView.colorRandom[2] = Color.parseColor((String)"#996699");
            ShineView.colorRandom[3] = Color.parseColor((String)"#FF6666");
            ShineView.colorRandom[4] = Color.parseColor((String)"#FFFF66");
            ShineView.colorRandom[5] = Color.parseColor((String)"#F44336");
            ShineView.colorRandom[6] = Color.parseColor((String)"#666666");
            ShineView.colorRandom[7] = Color.parseColor((String)"#CCCC00");
            ShineView.colorRandom[8] = Color.parseColor((String)"#666666");
            ShineView.colorRandom[9] = Color.parseColor((String)"#999933");
        }
    }
}

