/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.state;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Adapter;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import androidx.recyclerview.widget.RecyclerView;
import com.zzh.lib.views.R;
import com.zzh.lib.views.def.HStateEmptyStrategy;
import com.zzh.lib.views.def.IStateView;
import com.zzh.lib.views.state.HViewListener;
import com.zzh.lib.views.state.SimpleStateView;
import com.zzh.lib.views.state.empty.AdapterEmptyStrategy;
import com.zzh.lib.views.state.empty.RecyclerAdapterEmptyStrategy;
import java.util.HashSet;
import java.util.Set;

public class HStateLayout
extends FrameLayout {
    private ShowType mShowType = ShowType.Content;
    private IStateView mEmptyView;
    private IStateView mErrorView;
    private int resEmptyView = 0;
    private int resErrorView = 0;
    private final Set<IStateView> mStateViewHolder = new HashSet<IStateView>();
    private boolean mShowContentWhenState = true;
    private boolean mContentTop = true;
    private HStateEmptyStrategy mEmptyStrategy;
    private final HViewListener<View> mContentListener = new HViewListener<View>(){

        @Override
        protected void onUpdate(View view) {
            if (HStateLayout.this.mEmptyStrategy != null) {
                if (HStateLayout.this.mEmptyStrategy.isDestroyed()) {
                    HStateLayout.this.setEmptyStrategy(null);
                    return;
                }
                HStateEmptyStrategy.Result result = HStateLayout.this.mEmptyStrategy.getResult();
                if (result == null) {
                    throw new RuntimeException("Strategy result is null");
                }
                if (result == HStateEmptyStrategy.Result.Empty) {
                    if (HStateLayout.this.getShowType() == ShowType.Content) {
                        HStateLayout.this.setShowType(ShowType.Empty);
                    }
                } else if (result == HStateEmptyStrategy.Result.Content) {
                    HStateLayout.this.setShowType(ShowType.Content);
                }
            } else {
                HStateLayout.this.mContentListener.stop();
            }
        }

        @Override
        protected void onViewChanged(View oldView, View newView) {
            super.onViewChanged(oldView, newView);
            HStateLayout.this.onContentViewChanged(oldView, newView);
        }
    };

    public HStateLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public HStateLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public HStateLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.HStateLayout);
        if (ta.hasValue(R.styleable.HStateLayout_zh_sl_empty_view)) {
            this.resEmptyView = ta.getResourceId(R.styleable.HStateLayout_zh_sl_empty_view, 0);
        }
        if (ta.hasValue(R.styleable.HStateLayout_zh_sl_error_view)) {
            this.resErrorView = ta.getResourceId(R.styleable.HStateLayout_zh_sl_error_view, 0);
        }
        ta.recycle();
    }

    public ShowType getShowType() {
        return this.mShowType;
    }

    public HStateEmptyStrategy getEmptyStrategy() {
        return this.mEmptyStrategy;
    }

    public void setEmptyStrategy(HStateEmptyStrategy strategy) {
        if (this.mEmptyStrategy != strategy) {
            this.mEmptyStrategy = strategy;
            if (strategy != null) {
                if (HStateLayout.isAttached((View)this)) {
                    this.mContentListener.start();
                }
            } else {
                this.mContentListener.stop();
            }
        }
    }

    public void setShowContentWhenState(boolean show) {
        this.mShowContentWhenState = show;
    }

    public void setContentTop(boolean top) {
        this.mContentTop = top;
    }

    public void setShowType(ShowType showType) {
        if (showType == null) {
            throw new IllegalArgumentException("showType is null");
        }
        if (this.mShowType != showType) {
            this.mShowType = showType;
            this.updateShowTypeInternal();
        }
    }

    private void updateShowTypeInternal() {
        switch (this.mShowType) {
            case Content: {
                HStateLayout.showView(this.getContentView());
                this.hideStateView();
                break;
            }
            case Empty: {
                this.showStateView(this.getEmptyView());
                break;
            }
            case Error: {
                this.showStateView(this.getErrorView());
            }
        }
    }

    private void hideStateView() {
        for (IStateView item : this.mStateViewHolder) {
            HStateLayout.hideView((View)item);
        }
    }

    private void showStateView(IStateView stateView) {
        HStateLayout.showView((View)stateView);
        if (this.mShowContentWhenState) {
            HStateLayout.showView(this.getContentView());
        } else {
            HStateLayout.hideView(this.getContentView());
        }
        if (this.mContentTop) {
            if (this.mShowContentWhenState) {
                this.bringChildToFront(this.getContentView());
            }
        } else {
            this.bringChildToFront((View)stateView);
        }
        for (IStateView item : this.mStateViewHolder) {
            if (item == stateView) continue;
            HStateLayout.hideView((View)item);
        }
    }

    public View getContentView() {
        return this.mContentListener.getView();
    }

    public IStateView getErrorView() {
        return this.getErrorView(this.resErrorView);
    }

    public IStateView getErrorView(int resId) {
        if (this.mErrorView == null) {
            SimpleStateView simpleStateView = new SimpleStateView(this.getContext());
            this.mErrorView = simpleStateView;
            if (resId == 0) {
                int layoutId = HStateLayout.getLayoutId(this.getContext(), this.getResources().getString(R.string.zh_state_layout_error_layout));
                this.mErrorView.setContentView(layoutId);
            } else {
                this.mEmptyView.setContentView(resId);
            }
            this.addView((View)simpleStateView);
            HStateLayout.hideView((View)simpleStateView);
            this.mStateViewHolder.add(simpleStateView);
        }
        return this.mErrorView;
    }

    public IStateView getEmptyView() {
        return this.getEmptyView(this.resEmptyView);
    }

    public IStateView getEmptyView(int resId) {
        if (this.mEmptyView == null) {
            SimpleStateView simpleStateView = new SimpleStateView(this.getContext());
            this.mEmptyView = simpleStateView;
            if (resId == 0) {
                int layoutId = HStateLayout.getLayoutId(this.getContext(), this.getResources().getString(R.string.zh_state_layout_empty_layout));
                this.mEmptyView.setContentView(layoutId);
            } else {
                this.mEmptyView.setContentView(resId);
            }
            this.addView((View)simpleStateView);
            HStateLayout.hideView((View)simpleStateView);
            this.mStateViewHolder.add(simpleStateView);
        }
        return this.mEmptyView;
    }

    public void setContentView(View view) {
        this.mContentListener.setView(view);
    }

    public void onViewAdded(View child) {
        super.onViewAdded(child);
        int count = this.getChildCount();
        if (count == 1) {
            this.setContentView(this.getChildAt(0));
        } else if (count > 1 && child != this.mEmptyView && child != this.mErrorView) {
            throw new RuntimeException("Illegal child: " + child);
        }
    }

    public void onViewRemoved(View child) {
        super.onViewRemoved(child);
        if (this.getContentView() == child) {
            this.setContentView(null);
        }
        if (child instanceof IStateView) {
            this.mStateViewHolder.remove(child);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mContentListener.start();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mContentListener.stop();
    }

    protected void onContentViewChanged(View oldView, View newView) {
    }

    @Deprecated
    public void updateState(int dataCount) {
        if (dataCount > 0) {
            this.setShowType(ShowType.Content);
        } else {
            this.setShowType(ShowType.Empty);
        }
    }

    @Deprecated
    public void setAdapter(BaseAdapter adapter) {
        this.setEmptyStrategy(new AdapterEmptyStrategy((Adapter)adapter));
    }

    @Deprecated
    public void setAdapter(RecyclerView.Adapter adapter) {
        this.setEmptyStrategy(new RecyclerAdapterEmptyStrategy(adapter));
    }

    private static void hideView(View view) {
        if (view != null && view.getVisibility() != 8) {
            view.setVisibility(8);
        }
    }

    private static void showView(View view) {
        if (view != null && view.getVisibility() != 0) {
            view.setVisibility(0);
        }
    }

    private static int getLayoutId(Context context, String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return 0;
        }
        try {
            return context.getResources().getIdentifier(name, "layout", context.getPackageName());
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static boolean isAttached(View view) {
        if (view == null) {
            return false;
        }
        return view.isAttachedToWindow();
    }

    public static enum ShowType {
        Empty,
        Error,
        Content;

    }
}

