/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.state.empty;

import com.zzh.lib.views.def.HStateEmptyStrategy;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class CombineEmptyStrategy
implements HStateEmptyStrategy {
    private final List<HStateEmptyStrategy> mList = new CopyOnWriteArrayList<HStateEmptyStrategy>();

    public CombineEmptyStrategy(HStateEmptyStrategy ... strategies) {
        for (HStateEmptyStrategy item : strategies) {
            if (item == null) {
                throw new IllegalArgumentException("strategies item is null");
            }
            this.mList.add(item);
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.mList.isEmpty();
    }

    @Override
    public HStateEmptyStrategy.Result getResult() {
        for (HStateEmptyStrategy item : this.mList) {
            if (item.isDestroyed()) {
                this.mList.remove(item);
                continue;
            }
            HStateEmptyStrategy.Result itemResult = item.getResult();
            if (itemResult == HStateEmptyStrategy.Result.Content) {
                return HStateEmptyStrategy.Result.Content;
            }
            if (itemResult != HStateEmptyStrategy.Result.None) continue;
            return HStateEmptyStrategy.Result.None;
        }
        if (this.mList.isEmpty()) {
            return HStateEmptyStrategy.Result.None;
        }
        return HStateEmptyStrategy.Result.Empty;
    }
}

